/*
 * Decompiled with CFR 0.152.
 */
package com.xw.repo;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.util.Property;
import android.util.SparseArray;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.view.WindowManager;
import android.view.animation.LinearInterpolator;
import com.xw.repo.BubbleUtils;
import com.xw.repo.bubbleseekbar.R;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.math.BigDecimal;

public class BubbleSeekBar
extends View {
    static final int NONE = -1;
    private float mMin;
    private float mMax;
    private float mProgress;
    private boolean isFloatType;
    private int mTrackSize;
    private int mSecondTrackSize;
    private int mThumbRadius;
    private int mThumbRadiusOnDragging;
    private int mTrackColor;
    private int mSecondTrackColor;
    private int mThumbColor;
    private int mSectionCount;
    private boolean isShowSectionMark;
    private boolean isAutoAdjustSectionMark;
    private boolean isShowSectionText;
    private int mSectionTextSize;
    private int mSectionTextColor;
    private int mSectionTextPosition = -1;
    private int mSectionTextInterval;
    private boolean isShowThumbText;
    private int mThumbTextSize;
    private int mThumbTextColor;
    private boolean isShowProgressInFloat;
    private boolean isTouchToSeek;
    private boolean isSeekStepSection;
    private boolean isSeekBySection;
    private long mAnimDuration;
    private boolean isAlwaysShowBubble;
    private long mAlwaysShowBubbleDelay;
    private boolean isHideBubble;
    private boolean isRtl;
    private int mBubbleColor;
    private int mBubbleTextSize;
    private int mBubbleTextColor;
    private float mDelta;
    private float mSectionValue;
    private float mThumbCenterX;
    private float mTrackLength;
    private float mSectionOffset;
    private boolean isThumbOnDragging;
    private int mTextSpace;
    private boolean triggerBubbleShowing;
    private SparseArray<String> mSectionTextArray = new SparseArray();
    private float mPreThumbCenterX;
    private boolean triggerSeekBySection;
    private OnProgressChangedListener mProgressListener;
    private float mLeft;
    private float mRight;
    private Paint mPaint;
    private Rect mRectText;
    private WindowManager mWindowManager;
    private BubbleView mBubbleView;
    private int mBubbleRadius;
    private float mBubbleCenterRawSolidX;
    private float mBubbleCenterRawSolidY;
    private float mBubbleCenterRawX;
    private WindowManager.LayoutParams mLayoutParams;
    private int[] mPoint = new int[2];
    private boolean isTouchToSeekAnimEnd = true;
    private float mPreSecValue;
    float dx;

    public BubbleSeekBar(Context context) {
        this(context, null);
    }

    public BubbleSeekBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BubbleSeekBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.BubbleSeekBar, defStyleAttr, 0);
        this.mMin = a.getFloat(R.styleable.BubbleSeekBar_bsb_min, 0.0f);
        this.mMax = a.getFloat(R.styleable.BubbleSeekBar_bsb_max, 100.0f);
        this.mProgress = a.getFloat(R.styleable.BubbleSeekBar_bsb_progress, this.mMin);
        this.isFloatType = a.getBoolean(R.styleable.BubbleSeekBar_bsb_is_float_type, false);
        this.mTrackSize = a.getDimensionPixelSize(R.styleable.BubbleSeekBar_bsb_track_size, BubbleUtils.dp2px(2));
        this.mSecondTrackSize = a.getDimensionPixelSize(R.styleable.BubbleSeekBar_bsb_second_track_size, this.mTrackSize + BubbleUtils.dp2px(2));
        this.mThumbRadius = a.getDimensionPixelSize(R.styleable.BubbleSeekBar_bsb_thumb_radius, this.mSecondTrackSize + BubbleUtils.dp2px(2));
        this.mThumbRadiusOnDragging = a.getDimensionPixelSize(R.styleable.BubbleSeekBar_bsb_thumb_radius_on_dragging, this.mSecondTrackSize * 2);
        this.mSectionCount = a.getInteger(R.styleable.BubbleSeekBar_bsb_section_count, 10);
        this.mTrackColor = a.getColor(R.styleable.BubbleSeekBar_bsb_track_color, ContextCompat.getColor((Context)context, (int)R.color.colorPrimary));
        this.mSecondTrackColor = a.getColor(R.styleable.BubbleSeekBar_bsb_second_track_color, ContextCompat.getColor((Context)context, (int)R.color.colorAccent));
        this.mThumbColor = a.getColor(R.styleable.BubbleSeekBar_bsb_thumb_color, this.mSecondTrackColor);
        this.isShowSectionText = a.getBoolean(R.styleable.BubbleSeekBar_bsb_show_section_text, false);
        this.mSectionTextSize = a.getDimensionPixelSize(R.styleable.BubbleSeekBar_bsb_section_text_size, BubbleUtils.sp2px(14));
        this.mSectionTextColor = a.getColor(R.styleable.BubbleSeekBar_bsb_section_text_color, this.mTrackColor);
        this.isSeekStepSection = a.getBoolean(R.styleable.BubbleSeekBar_bsb_seek_step_section, false);
        this.isSeekBySection = a.getBoolean(R.styleable.BubbleSeekBar_bsb_seek_by_section, false);
        int pos = a.getInteger(R.styleable.BubbleSeekBar_bsb_section_text_position, -1);
        this.mSectionTextPosition = pos == 0 ? 0 : (pos == 1 ? 1 : (pos == 2 ? 2 : -1));
        this.mSectionTextInterval = a.getInteger(R.styleable.BubbleSeekBar_bsb_section_text_interval, 1);
        this.isShowThumbText = a.getBoolean(R.styleable.BubbleSeekBar_bsb_show_thumb_text, false);
        this.mThumbTextSize = a.getDimensionPixelSize(R.styleable.BubbleSeekBar_bsb_thumb_text_size, BubbleUtils.sp2px(14));
        this.mThumbTextColor = a.getColor(R.styleable.BubbleSeekBar_bsb_thumb_text_color, this.mSecondTrackColor);
        this.mBubbleColor = a.getColor(R.styleable.BubbleSeekBar_bsb_bubble_color, this.mSecondTrackColor);
        this.mBubbleTextSize = a.getDimensionPixelSize(R.styleable.BubbleSeekBar_bsb_bubble_text_size, BubbleUtils.sp2px(14));
        this.mBubbleTextColor = a.getColor(R.styleable.BubbleSeekBar_bsb_bubble_text_color, -1);
        this.isShowSectionMark = a.getBoolean(R.styleable.BubbleSeekBar_bsb_show_section_mark, false);
        this.isAutoAdjustSectionMark = a.getBoolean(R.styleable.BubbleSeekBar_bsb_auto_adjust_section_mark, false);
        this.isShowProgressInFloat = a.getBoolean(R.styleable.BubbleSeekBar_bsb_show_progress_in_float, false);
        int duration = a.getInteger(R.styleable.BubbleSeekBar_bsb_anim_duration, -1);
        this.mAnimDuration = duration < 0 ? 200L : (long)duration;
        this.isTouchToSeek = a.getBoolean(R.styleable.BubbleSeekBar_bsb_touch_to_seek, false);
        this.isAlwaysShowBubble = a.getBoolean(R.styleable.BubbleSeekBar_bsb_always_show_bubble, false);
        duration = a.getInteger(R.styleable.BubbleSeekBar_bsb_always_show_bubble_delay, 0);
        this.mAlwaysShowBubbleDelay = duration < 0 ? 0L : (long)duration;
        this.isHideBubble = a.getBoolean(R.styleable.BubbleSeekBar_bsb_hide_bubble, false);
        this.isRtl = a.getBoolean(R.styleable.BubbleSeekBar_bsb_rtl, false);
        a.recycle();
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mPaint.setTextAlign(Paint.Align.CENTER);
        this.mRectText = new Rect();
        this.mTextSpace = BubbleUtils.dp2px(2);
        this.initConfigByPriority();
        if (this.isHideBubble) {
            return;
        }
        this.mWindowManager = (WindowManager)context.getSystemService("window");
        this.mBubbleView = new BubbleView(context);
        this.mBubbleView.setProgressText(this.isShowProgressInFloat ? String.valueOf(this.getProgressFloat()) : String.valueOf(this.getProgress()));
        this.mLayoutParams = new WindowManager.LayoutParams();
        this.mLayoutParams.gravity = 0x800033;
        this.mLayoutParams.width = -2;
        this.mLayoutParams.height = -2;
        this.mLayoutParams.format = -3;
        this.mLayoutParams.flags = 524328;
        this.mLayoutParams.type = BubbleUtils.isMIUI() || Build.VERSION.SDK_INT >= 25 ? 2 : 2005;
        this.calculateRadiusOfBubble();
    }

    private void initConfigByPriority() {
        if (this.mMin == this.mMax) {
            this.mMin = 0.0f;
            this.mMax = 100.0f;
        }
        if (this.mMin > this.mMax) {
            float tmp = this.mMax;
            this.mMax = this.mMin;
            this.mMin = tmp;
        }
        if (this.mProgress < this.mMin) {
            this.mProgress = this.mMin;
        }
        if (this.mProgress > this.mMax) {
            this.mProgress = this.mMax;
        }
        if (this.mSecondTrackSize < this.mTrackSize) {
            this.mSecondTrackSize = this.mTrackSize + BubbleUtils.dp2px(2);
        }
        if (this.mThumbRadius <= this.mSecondTrackSize) {
            this.mThumbRadius = this.mSecondTrackSize + BubbleUtils.dp2px(2);
        }
        if (this.mThumbRadiusOnDragging <= this.mSecondTrackSize) {
            this.mThumbRadiusOnDragging = this.mSecondTrackSize * 2;
        }
        if (this.mSectionCount <= 0) {
            this.mSectionCount = 10;
        }
        this.mDelta = this.mMax - this.mMin;
        this.mSectionValue = this.mDelta / (float)this.mSectionCount;
        if (this.mSectionValue < 1.0f) {
            this.isFloatType = true;
        }
        if (this.isFloatType) {
            this.isShowProgressInFloat = true;
        }
        if (this.mSectionTextPosition != -1) {
            this.isShowSectionText = true;
        }
        if (this.isShowSectionText) {
            if (this.mSectionTextPosition == -1) {
                this.mSectionTextPosition = 0;
            }
            if (this.mSectionTextPosition == 2) {
                this.isShowSectionMark = true;
            }
        }
        if (this.mSectionTextInterval < 1) {
            this.mSectionTextInterval = 1;
        }
        this.initSectionTextArray();
        if (this.isSeekStepSection) {
            this.isSeekBySection = false;
            this.isAutoAdjustSectionMark = false;
        }
        if (this.isAutoAdjustSectionMark && !this.isShowSectionMark) {
            this.isAutoAdjustSectionMark = false;
        }
        if (this.isSeekBySection) {
            this.mPreSecValue = this.mMin;
            if (this.mProgress != this.mMin) {
                this.mPreSecValue = this.mSectionValue;
            }
            this.isShowSectionMark = true;
            this.isAutoAdjustSectionMark = true;
        }
        if (this.isHideBubble) {
            this.isAlwaysShowBubble = false;
        }
        if (this.isAlwaysShowBubble) {
            this.setProgress(this.mProgress);
        }
        this.mThumbTextSize = this.isFloatType || this.isSeekBySection || this.isShowSectionText && this.mSectionTextPosition == 2 ? this.mSectionTextSize : this.mThumbTextSize;
    }

    private void calculateRadiusOfBubble() {
        this.mPaint.setTextSize((float)this.mBubbleTextSize);
        String text = this.isShowProgressInFloat ? this.float2String(this.isRtl ? this.mMax : this.mMin) : (this.isRtl ? (this.isFloatType ? this.float2String(this.mMax) : String.valueOf((int)this.mMax)) : (this.isFloatType ? this.float2String(this.mMin) : String.valueOf((int)this.mMin)));
        this.mPaint.getTextBounds(text, 0, text.length(), this.mRectText);
        int w1 = this.mRectText.width() + this.mTextSpace * 2 >> 1;
        text = this.isShowProgressInFloat ? this.float2String(this.isRtl ? this.mMin : this.mMax) : (this.isRtl ? (this.isFloatType ? this.float2String(this.mMin) : String.valueOf((int)this.mMin)) : (this.isFloatType ? this.float2String(this.mMax) : String.valueOf((int)this.mMax)));
        this.mPaint.getTextBounds(text, 0, text.length(), this.mRectText);
        int w2 = this.mRectText.width() + this.mTextSpace * 2 >> 1;
        this.mBubbleRadius = BubbleUtils.dp2px(14);
        int max = Math.max(this.mBubbleRadius, Math.max(w1, w2));
        this.mBubbleRadius = max + this.mTextSpace;
    }

    private void initSectionTextArray() {
        boolean ifBelowSection = this.mSectionTextPosition == 2;
        boolean ifInterval = this.mSectionTextInterval > 1 && this.mSectionCount % 2 == 0;
        for (int i = 0; i <= this.mSectionCount; ++i) {
            float sectionValue;
            float f = sectionValue = this.isRtl ? this.mMax - this.mSectionValue * (float)i : this.mMin + this.mSectionValue * (float)i;
            if (ifBelowSection) {
                if (ifInterval) {
                    if (i % this.mSectionTextInterval != 0) continue;
                    sectionValue = this.isRtl ? this.mMax - this.mSectionValue * (float)i : this.mMin + this.mSectionValue * (float)i;
                }
            } else if (i != 0 && i != this.mSectionCount) continue;
            this.mSectionTextArray.put(i, (Object)(this.isFloatType ? this.float2String(sectionValue) : (int)sectionValue + ""));
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int height = this.mThumbRadiusOnDragging * 2;
        if (this.isShowThumbText) {
            this.mPaint.setTextSize((float)this.mThumbTextSize);
            this.mPaint.getTextBounds("j", 0, 1, this.mRectText);
            height += this.mRectText.height();
        }
        if (this.isShowSectionText && this.mSectionTextPosition >= 1) {
            this.mPaint.setTextSize((float)this.mSectionTextSize);
            this.mPaint.getTextBounds("j", 0, 1, this.mRectText);
            height = Math.max(height, this.mThumbRadiusOnDragging * 2 + this.mRectText.height());
        }
        this.setMeasuredDimension(BubbleSeekBar.resolveSize((int)BubbleUtils.dp2px(180), (int)widthMeasureSpec), height += this.mTextSpace * 2);
        this.mLeft = this.getPaddingLeft() + this.mThumbRadiusOnDragging;
        this.mRight = this.getMeasuredWidth() - this.getPaddingRight() - this.mThumbRadiusOnDragging;
        if (this.isShowSectionText) {
            this.mPaint.setTextSize((float)this.mSectionTextSize);
            if (this.mSectionTextPosition == 0) {
                String text = (String)this.mSectionTextArray.get(0);
                this.mPaint.getTextBounds(text, 0, text.length(), this.mRectText);
                this.mLeft += (float)(this.mRectText.width() + this.mTextSpace);
                text = (String)this.mSectionTextArray.get(this.mSectionCount);
                this.mPaint.getTextBounds(text, 0, text.length(), this.mRectText);
                this.mRight -= (float)(this.mRectText.width() + this.mTextSpace);
            } else if (this.mSectionTextPosition >= 1) {
                String text = (String)this.mSectionTextArray.get(0);
                this.mPaint.getTextBounds(text, 0, text.length(), this.mRectText);
                float max = Math.max((float)this.mThumbRadiusOnDragging, (float)this.mRectText.width() / 2.0f);
                this.mLeft = (float)this.getPaddingLeft() + max + (float)this.mTextSpace;
                text = (String)this.mSectionTextArray.get(this.mSectionCount);
                this.mPaint.getTextBounds(text, 0, text.length(), this.mRectText);
                max = Math.max((float)this.mThumbRadiusOnDragging, (float)this.mRectText.width() / 2.0f);
                this.mRight = (float)(this.getMeasuredWidth() - this.getPaddingRight()) - max - (float)this.mTextSpace;
            }
        } else if (this.isShowThumbText && this.mSectionTextPosition == -1) {
            this.mPaint.setTextSize((float)this.mThumbTextSize);
            String text = (String)this.mSectionTextArray.get(0);
            this.mPaint.getTextBounds(text, 0, text.length(), this.mRectText);
            float max = Math.max((float)this.mThumbRadiusOnDragging, (float)this.mRectText.width() / 2.0f);
            this.mLeft = (float)this.getPaddingLeft() + max + (float)this.mTextSpace;
            text = (String)this.mSectionTextArray.get(this.mSectionCount);
            this.mPaint.getTextBounds(text, 0, text.length(), this.mRectText);
            max = Math.max((float)this.mThumbRadiusOnDragging, (float)this.mRectText.width() / 2.0f);
            this.mRight = (float)(this.getMeasuredWidth() - this.getPaddingRight()) - max - (float)this.mTextSpace;
        }
        this.mTrackLength = this.mRight - this.mLeft;
        this.mSectionOffset = this.mTrackLength * 1.0f / (float)this.mSectionCount;
        if (!this.isHideBubble) {
            this.mBubbleView.measure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (!this.isHideBubble) {
            this.locatePositionOnScreen();
        }
    }

    private void locatePositionOnScreen() {
        int flags;
        Window window;
        Context context;
        this.getLocationOnScreen(this.mPoint);
        ViewParent parent = this.getParent();
        if (parent != null && parent instanceof View && ((View)parent).getMeasuredWidth() > 0) {
            this.mPoint[0] = this.mPoint[0] % ((View)parent).getMeasuredWidth();
        }
        this.mBubbleCenterRawSolidX = this.isRtl ? (float)this.mPoint[0] + this.mRight - (float)this.mBubbleView.getMeasuredWidth() / 2.0f : (float)this.mPoint[0] + this.mLeft - (float)this.mBubbleView.getMeasuredWidth() / 2.0f;
        this.mBubbleCenterRawX = this.calculateCenterRawXofBubbleView();
        this.mBubbleCenterRawSolidY = this.mPoint[1] - this.mBubbleView.getMeasuredHeight();
        this.mBubbleCenterRawSolidY -= (float)BubbleUtils.dp2px(24);
        if (BubbleUtils.isMIUI()) {
            this.mBubbleCenterRawSolidY += (float)BubbleUtils.dp2px(4);
        }
        if ((context = this.getContext()) instanceof Activity && (window = ((Activity)context).getWindow()) != null && ((flags = window.getAttributes().flags) & 0x400) != 0) {
            Resources res = Resources.getSystem();
            int id = res.getIdentifier("status_bar_height", "dimen", "android");
            this.mBubbleCenterRawSolidY += (float)res.getDimensionPixelSize(id);
        }
    }

    protected void onDraw(Canvas canvas) {
        boolean isShowTextBelowSectionMark;
        super.onDraw(canvas);
        float xLeft = this.getPaddingLeft();
        float xRight = this.getMeasuredWidth() - this.getPaddingRight();
        float yTop = this.getPaddingTop() + this.mThumbRadiusOnDragging;
        if (this.isShowSectionText) {
            String text;
            float y_;
            this.mPaint.setColor(this.mSectionTextColor);
            this.mPaint.setTextSize((float)this.mSectionTextSize);
            this.mPaint.getTextBounds("0123456789", 0, "0123456789".length(), this.mRectText);
            if (this.mSectionTextPosition == 0) {
                y_ = yTop + (float)this.mRectText.height() / 2.0f;
                text = (String)this.mSectionTextArray.get(0);
                this.mPaint.getTextBounds(text, 0, text.length(), this.mRectText);
                canvas.drawText(text, xLeft + (float)this.mRectText.width() / 2.0f, y_, this.mPaint);
                xLeft += (float)(this.mRectText.width() + this.mTextSpace);
                text = (String)this.mSectionTextArray.get(this.mSectionCount);
                this.mPaint.getTextBounds(text, 0, text.length(), this.mRectText);
                canvas.drawText(text, xRight - ((float)this.mRectText.width() + 0.5f) / 2.0f, y_, this.mPaint);
                xRight -= (float)(this.mRectText.width() + this.mTextSpace);
            } else if (this.mSectionTextPosition >= 1) {
                y_ = yTop + (float)this.mThumbRadiusOnDragging + (float)this.mTextSpace;
                text = (String)this.mSectionTextArray.get(0);
                this.mPaint.getTextBounds(text, 0, text.length(), this.mRectText);
                y_ += (float)this.mRectText.height();
                xLeft = this.mLeft;
                if (this.mSectionTextPosition == 1) {
                    canvas.drawText(text, xLeft, y_, this.mPaint);
                }
                text = (String)this.mSectionTextArray.get(this.mSectionCount);
                this.mPaint.getTextBounds(text, 0, text.length(), this.mRectText);
                xRight = this.mRight;
                if (this.mSectionTextPosition == 1) {
                    canvas.drawText(text, xRight, y_, this.mPaint);
                }
            }
        } else if (this.isShowThumbText && this.mSectionTextPosition == -1) {
            xLeft = this.mLeft;
            xRight = this.mRight;
        }
        if (!this.isShowSectionText && !this.isShowThumbText || this.mSectionTextPosition == 0) {
            xLeft += (float)this.mThumbRadiusOnDragging;
            xRight -= (float)this.mThumbRadiusOnDragging;
        }
        boolean bl = isShowTextBelowSectionMark = this.isShowSectionText && this.mSectionTextPosition == 2;
        if (isShowTextBelowSectionMark || this.isShowSectionMark) {
            this.mPaint.setTextSize((float)this.mSectionTextSize);
            this.mPaint.getTextBounds("0123456789", 0, "0123456789".length(), this.mRectText);
            float y_ = yTop + (float)this.mRectText.height() + (float)this.mThumbRadiusOnDragging + (float)this.mTextSpace;
            float r = (float)(this.mThumbRadiusOnDragging - BubbleUtils.dp2px(2)) / 2.0f;
            float junction = this.isRtl ? this.mRight - this.mTrackLength / this.mDelta * Math.abs(this.mProgress - this.mMin) : this.mLeft + this.mTrackLength / this.mDelta * Math.abs(this.mProgress - this.mMin);
            for (int i = 0; i <= this.mSectionCount; ++i) {
                float x_ = xLeft + (float)i * this.mSectionOffset;
                if (this.isRtl) {
                    this.mPaint.setColor(x_ <= junction ? this.mTrackColor : this.mSecondTrackColor);
                } else {
                    this.mPaint.setColor(x_ <= junction ? this.mSecondTrackColor : this.mTrackColor);
                }
                canvas.drawCircle(x_, yTop, r, this.mPaint);
                if (!isShowTextBelowSectionMark) continue;
                this.mPaint.setColor(this.mSectionTextColor);
                if (this.mSectionTextArray.get(i, null) == null) continue;
                canvas.drawText((String)this.mSectionTextArray.get(i), x_, y_, this.mPaint);
            }
        }
        if (!this.isThumbOnDragging || this.isAlwaysShowBubble) {
            this.mThumbCenterX = this.isRtl ? xRight - this.mTrackLength / this.mDelta * (this.mProgress - this.mMin) : xLeft + this.mTrackLength / this.mDelta * (this.mProgress - this.mMin);
        }
        if (this.isShowThumbText && !this.isThumbOnDragging && this.isTouchToSeekAnimEnd) {
            this.mPaint.setColor(this.mThumbTextColor);
            this.mPaint.setTextSize((float)this.mThumbTextSize);
            this.mPaint.getTextBounds("0123456789", 0, "0123456789".length(), this.mRectText);
            float y_ = yTop + (float)this.mRectText.height() + (float)this.mThumbRadiusOnDragging + (float)this.mTextSpace;
            if (this.isFloatType || this.isShowProgressInFloat && this.mSectionTextPosition == 1 && this.mProgress != this.mMin && this.mProgress != this.mMax) {
                canvas.drawText(String.valueOf(this.getProgressFloat()), this.mThumbCenterX, y_, this.mPaint);
            } else {
                canvas.drawText(String.valueOf(this.getProgress()), this.mThumbCenterX, y_, this.mPaint);
            }
        }
        this.mPaint.setColor(this.mSecondTrackColor);
        this.mPaint.setStrokeWidth((float)this.mSecondTrackSize);
        if (this.isRtl) {
            canvas.drawLine(xRight, yTop, this.mThumbCenterX, yTop, this.mPaint);
        } else {
            canvas.drawLine(xLeft, yTop, this.mThumbCenterX, yTop, this.mPaint);
        }
        this.mPaint.setColor(this.mTrackColor);
        this.mPaint.setStrokeWidth((float)this.mTrackSize);
        if (this.isRtl) {
            canvas.drawLine(this.mThumbCenterX, yTop, xLeft, yTop, this.mPaint);
        } else {
            canvas.drawLine(this.mThumbCenterX, yTop, xRight, yTop, this.mPaint);
        }
        this.mPaint.setColor(this.mThumbColor);
        canvas.drawCircle(this.mThumbCenterX, yTop, this.isThumbOnDragging ? (float)this.mThumbRadiusOnDragging : (float)this.mThumbRadius, this.mPaint);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.post(new Runnable(){

            @Override
            public void run() {
                BubbleSeekBar.this.requestLayout();
            }
        });
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        if (this.isHideBubble || !this.isAlwaysShowBubble) {
            return;
        }
        if (visibility != 0) {
            this.hideBubble();
        } else if (this.triggerBubbleShowing) {
            this.showBubble();
        }
        super.onVisibilityChanged(changedView, visibility);
    }

    protected void onDetachedFromWindow() {
        this.hideBubble();
        super.onDetachedFromWindow();
    }

    public boolean performClick() {
        return super.performClick();
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getActionMasked()) {
            case 0: {
                this.performClick();
                this.getParent().requestDisallowInterceptTouchEvent(true);
                this.isThumbOnDragging = this.isThumbTouched(event);
                if (this.isThumbOnDragging) {
                    if (this.isSeekBySection && !this.triggerSeekBySection) {
                        this.triggerSeekBySection = true;
                    }
                    if (this.isAlwaysShowBubble && !this.triggerBubbleShowing) {
                        this.triggerBubbleShowing = true;
                    }
                    if (!this.isHideBubble) {
                        this.showBubble();
                    }
                    this.invalidate();
                } else if (this.isTouchToSeek && this.isTrackTouched(event)) {
                    this.isThumbOnDragging = true;
                    if (this.isSeekBySection && !this.triggerSeekBySection) {
                        this.triggerSeekBySection = true;
                    }
                    if (this.isAlwaysShowBubble) {
                        this.hideBubble();
                        this.triggerBubbleShowing = true;
                    }
                    if (this.isSeekStepSection) {
                        this.mThumbCenterX = this.mPreThumbCenterX = this.calThumbCxWhenSeekStepSection(event.getX());
                    } else {
                        this.mThumbCenterX = event.getX();
                        if (this.mThumbCenterX < this.mLeft) {
                            this.mThumbCenterX = this.mLeft;
                        }
                        if (this.mThumbCenterX > this.mRight) {
                            this.mThumbCenterX = this.mRight;
                        }
                    }
                    this.mProgress = this.calculateProgress();
                    if (!this.isHideBubble) {
                        this.mBubbleCenterRawX = this.calculateCenterRawXofBubbleView();
                        this.showBubble();
                    }
                    this.invalidate();
                }
                this.dx = this.mThumbCenterX - event.getX();
                break;
            }
            case 2: {
                if (!this.isThumbOnDragging) break;
                boolean flag = true;
                if (this.isSeekStepSection) {
                    float x = this.calThumbCxWhenSeekStepSection(event.getX());
                    if (x != this.mPreThumbCenterX) {
                        this.mThumbCenterX = this.mPreThumbCenterX = x;
                    } else {
                        flag = false;
                    }
                } else {
                    this.mThumbCenterX = event.getX() + this.dx;
                    if (this.mThumbCenterX < this.mLeft) {
                        this.mThumbCenterX = this.mLeft;
                    }
                    if (this.mThumbCenterX > this.mRight) {
                        this.mThumbCenterX = this.mRight;
                    }
                }
                if (!flag) break;
                this.mProgress = this.calculateProgress();
                if (!this.isHideBubble && this.mBubbleView.getParent() != null) {
                    this.mBubbleCenterRawX = this.calculateCenterRawXofBubbleView();
                    this.mLayoutParams.x = (int)(this.mBubbleCenterRawX + 0.5f);
                    this.mWindowManager.updateViewLayout((View)this.mBubbleView, (ViewGroup.LayoutParams)this.mLayoutParams);
                    this.mBubbleView.setProgressText(this.isShowProgressInFloat ? String.valueOf(this.getProgressFloat()) : String.valueOf(this.getProgress()));
                }
                this.invalidate();
                if (this.mProgressListener == null) break;
                this.mProgressListener.onProgressChanged(this, this.getProgress(), this.getProgressFloat());
                break;
            }
            case 1: 
            case 3: {
                this.getParent().requestDisallowInterceptTouchEvent(false);
                if (this.isAutoAdjustSectionMark) {
                    if (this.isTouchToSeek) {
                        this.postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                BubbleSeekBar.this.isTouchToSeekAnimEnd = false;
                                BubbleSeekBar.this.autoAdjustSection();
                            }
                        }, this.mAnimDuration);
                    } else {
                        this.autoAdjustSection();
                    }
                } else if (this.isThumbOnDragging || this.isTouchToSeek) {
                    if (this.isHideBubble) {
                        this.animate().setDuration(this.mAnimDuration).setStartDelay(!this.isThumbOnDragging && this.isTouchToSeek ? 300L : 0L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                            public void onAnimationEnd(Animator animation) {
                                BubbleSeekBar.this.isThumbOnDragging = false;
                                BubbleSeekBar.this.invalidate();
                            }

                            public void onAnimationCancel(Animator animation) {
                                BubbleSeekBar.this.isThumbOnDragging = false;
                                BubbleSeekBar.this.invalidate();
                            }
                        }).start();
                    } else {
                        this.postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                BubbleSeekBar.this.mBubbleView.animate().alpha(BubbleSeekBar.this.isAlwaysShowBubble ? 1.0f : 0.0f).setDuration(BubbleSeekBar.this.mAnimDuration).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                                    public void onAnimationEnd(Animator animation) {
                                        if (!BubbleSeekBar.this.isAlwaysShowBubble) {
                                            BubbleSeekBar.this.hideBubble();
                                        }
                                        BubbleSeekBar.this.isThumbOnDragging = false;
                                        BubbleSeekBar.this.invalidate();
                                    }

                                    public void onAnimationCancel(Animator animation) {
                                        if (!BubbleSeekBar.this.isAlwaysShowBubble) {
                                            BubbleSeekBar.this.hideBubble();
                                        }
                                        BubbleSeekBar.this.isThumbOnDragging = false;
                                        BubbleSeekBar.this.invalidate();
                                    }
                                }).start();
                            }
                        }, this.mAnimDuration);
                    }
                }
                if (this.mProgressListener == null) break;
                this.mProgressListener.onProgressChanged(this, this.getProgress(), this.getProgressFloat());
                this.mProgressListener.getProgressOnActionUp(this, this.getProgress(), this.getProgressFloat());
            }
        }
        return this.isThumbOnDragging || this.isTouchToSeek || super.onTouchEvent(event);
    }

    private boolean isThumbTouched(MotionEvent event) {
        if (!this.isEnabled()) {
            return false;
        }
        float distance = this.mTrackLength / this.mDelta * (this.mProgress - this.mMin);
        float x = this.isRtl ? this.mRight - distance : this.mLeft + distance;
        float y = (float)this.getMeasuredHeight() / 2.0f;
        return (event.getX() - x) * (event.getX() - x) + (event.getY() - y) * (event.getY() - y) <= (this.mLeft + (float)BubbleUtils.dp2px(8)) * (this.mLeft + (float)BubbleUtils.dp2px(8));
    }

    private boolean isTrackTouched(MotionEvent event) {
        return this.isEnabled() && event.getX() >= (float)this.getPaddingLeft() && event.getX() <= (float)(this.getMeasuredWidth() - this.getPaddingRight()) && event.getY() >= (float)this.getPaddingTop() && event.getY() <= (float)(this.getMeasuredHeight() - this.getPaddingBottom());
    }

    private float calThumbCxWhenSeekStepSection(float touchedX) {
        int i;
        if (touchedX <= this.mLeft) {
            return this.mLeft;
        }
        if (touchedX >= this.mRight) {
            return this.mRight;
        }
        float x = 0.0f;
        for (i = 0; !(i > this.mSectionCount || (x = (float)i * this.mSectionOffset + this.mLeft) <= touchedX && touchedX - x <= this.mSectionOffset); ++i) {
        }
        if (touchedX - x <= this.mSectionOffset / 2.0f) {
            return x;
        }
        return (float)(i + 1) * this.mSectionOffset + this.mLeft;
    }

    private void autoAdjustSection() {
        int i;
        float x = 0.0f;
        for (i = 0; !(i > this.mSectionCount || (x = (float)i * this.mSectionOffset + this.mLeft) <= this.mThumbCenterX && this.mThumbCenterX - x <= this.mSectionOffset); ++i) {
        }
        BigDecimal bigDecimal = BigDecimal.valueOf(this.mThumbCenterX);
        float x_ = bigDecimal.setScale(1, 4).floatValue();
        boolean onSection = x_ == x;
        AnimatorSet animatorSet = new AnimatorSet();
        ValueAnimator valueAnim = null;
        if (!onSection) {
            valueAnim = this.mThumbCenterX - x <= this.mSectionOffset / 2.0f ? ValueAnimator.ofFloat((float[])new float[]{this.mThumbCenterX, x}) : ValueAnimator.ofFloat((float[])new float[]{this.mThumbCenterX, (float)(i + 1) * this.mSectionOffset + this.mLeft});
            valueAnim.setInterpolator((TimeInterpolator)new LinearInterpolator());
            valueAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    BubbleSeekBar.this.mThumbCenterX = ((Float)animation.getAnimatedValue()).floatValue();
                    BubbleSeekBar.this.mProgress = BubbleSeekBar.this.calculateProgress();
                    if (!BubbleSeekBar.this.isHideBubble) {
                        BubbleSeekBar.this.mBubbleCenterRawX = BubbleSeekBar.this.calculateCenterRawXofBubbleView();
                        ((BubbleSeekBar)BubbleSeekBar.this).mLayoutParams.x = (int)(BubbleSeekBar.this.mBubbleCenterRawX + 0.5f);
                        if (BubbleSeekBar.this.mBubbleView.getParent() != null) {
                            BubbleSeekBar.this.mWindowManager.updateViewLayout((View)BubbleSeekBar.this.mBubbleView, (ViewGroup.LayoutParams)BubbleSeekBar.this.mLayoutParams);
                        }
                        BubbleSeekBar.this.mBubbleView.setProgressText(BubbleSeekBar.this.isShowProgressInFloat ? String.valueOf(BubbleSeekBar.this.getProgressFloat()) : String.valueOf(BubbleSeekBar.this.getProgress()));
                    }
                    BubbleSeekBar.this.invalidate();
                    if (BubbleSeekBar.this.mProgressListener != null) {
                        BubbleSeekBar.this.mProgressListener.onProgressChanged(BubbleSeekBar.this, BubbleSeekBar.this.getProgress(), BubbleSeekBar.this.getProgressFloat());
                    }
                }
            });
        }
        if (this.isHideBubble) {
            if (!onSection) {
                animatorSet.setDuration(this.mAnimDuration).playTogether(new Animator[]{valueAnim});
            }
        } else {
            ObjectAnimator alphaAnim = ObjectAnimator.ofFloat((Object)((Object)this.mBubbleView), (Property)View.ALPHA, (float[])new float[]{this.isAlwaysShowBubble ? 1.0f : 0.0f});
            if (onSection) {
                animatorSet.setDuration(this.mAnimDuration).play((Animator)alphaAnim);
            } else {
                animatorSet.setDuration(this.mAnimDuration).playTogether(new Animator[]{valueAnim, alphaAnim});
            }
        }
        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                if (!BubbleSeekBar.this.isHideBubble && !BubbleSeekBar.this.isAlwaysShowBubble) {
                    BubbleSeekBar.this.hideBubble();
                }
                BubbleSeekBar.this.mProgress = BubbleSeekBar.this.calculateProgress();
                BubbleSeekBar.this.isThumbOnDragging = false;
                BubbleSeekBar.this.isTouchToSeekAnimEnd = true;
                BubbleSeekBar.this.invalidate();
                if (BubbleSeekBar.this.mProgressListener != null) {
                    BubbleSeekBar.this.mProgressListener.getProgressOnFinally(BubbleSeekBar.this, BubbleSeekBar.this.getProgress(), BubbleSeekBar.this.getProgressFloat());
                }
            }

            public void onAnimationCancel(Animator animation) {
                if (!BubbleSeekBar.this.isHideBubble && !BubbleSeekBar.this.isAlwaysShowBubble) {
                    BubbleSeekBar.this.hideBubble();
                }
                BubbleSeekBar.this.mProgress = BubbleSeekBar.this.calculateProgress();
                BubbleSeekBar.this.isThumbOnDragging = false;
                BubbleSeekBar.this.isTouchToSeekAnimEnd = true;
                BubbleSeekBar.this.invalidate();
            }
        });
        animatorSet.start();
    }

    private void showBubble() {
        if (this.mBubbleView == null || this.mBubbleView.getParent() != null) {
            return;
        }
        this.mLayoutParams.x = (int)(this.mBubbleCenterRawX + 0.5f);
        this.mLayoutParams.y = (int)(this.mBubbleCenterRawSolidY + 0.5f);
        this.mBubbleView.setAlpha(0.0f);
        this.mBubbleView.setVisibility(0);
        this.mBubbleView.animate().alpha(1.0f).setDuration(this.isTouchToSeek ? 0L : this.mAnimDuration).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                BubbleSeekBar.this.mWindowManager.addView((View)BubbleSeekBar.this.mBubbleView, (ViewGroup.LayoutParams)BubbleSeekBar.this.mLayoutParams);
            }
        }).start();
        this.mBubbleView.setProgressText(this.isShowProgressInFloat ? String.valueOf(this.getProgressFloat()) : String.valueOf(this.getProgress()));
    }

    private void hideBubble() {
        if (this.mBubbleView == null) {
            return;
        }
        this.mBubbleView.setVisibility(8);
        if (this.mBubbleView.getParent() != null) {
            this.mWindowManager.removeViewImmediate((View)this.mBubbleView);
        }
    }

    private String float2String(float value) {
        return String.valueOf(this.formatFloat(value));
    }

    private float formatFloat(float value) {
        BigDecimal bigDecimal = BigDecimal.valueOf(value);
        return bigDecimal.setScale(1, 4).floatValue();
    }

    private float calculateCenterRawXofBubbleView() {
        if (this.isRtl) {
            return this.mBubbleCenterRawSolidX - this.mTrackLength * (this.mProgress - this.mMin) / this.mDelta;
        }
        return this.mBubbleCenterRawSolidX + this.mTrackLength * (this.mProgress - this.mMin) / this.mDelta;
    }

    private float calculateProgress() {
        if (this.isRtl) {
            return (this.mRight - this.mThumbCenterX) * this.mDelta / this.mTrackLength + this.mMin;
        }
        return (this.mThumbCenterX - this.mLeft) * this.mDelta / this.mTrackLength + this.mMin;
    }

    public void correctOffsetWhenContainerOnScrolling() {
        if (this.isHideBubble) {
            return;
        }
        this.locatePositionOnScreen();
        if (this.mBubbleView.getParent() != null) {
            if (this.isAlwaysShowBubble) {
                this.mLayoutParams.y = (int)(this.mBubbleCenterRawSolidY + 0.5f);
                this.mWindowManager.updateViewLayout((View)this.mBubbleView, (ViewGroup.LayoutParams)this.mLayoutParams);
            } else {
                this.postInvalidate();
            }
        }
    }

    public float getMin() {
        return this.mMin;
    }

    public float getMax() {
        return this.mMax;
    }

    public void setProgress(float progress) {
        this.mProgress = progress;
        if (this.mProgressListener != null) {
            this.mProgressListener.onProgressChanged(this, this.getProgress(), this.getProgressFloat());
            this.mProgressListener.getProgressOnFinally(this, this.getProgress(), this.getProgressFloat());
        }
        if (!this.isHideBubble) {
            this.mBubbleCenterRawX = this.calculateCenterRawXofBubbleView();
        }
        if (this.isAlwaysShowBubble) {
            this.hideBubble();
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    BubbleSeekBar.this.showBubble();
                    BubbleSeekBar.this.triggerBubbleShowing = true;
                }
            }, this.mAlwaysShowBubbleDelay);
        }
        if (this.isSeekBySection) {
            this.triggerSeekBySection = false;
        }
        this.postInvalidate();
    }

    public int getProgress() {
        return Math.round(this.processProgress());
    }

    public float getProgressFloat() {
        return this.formatFloat(this.processProgress());
    }

    private float processProgress() {
        float progress = this.mProgress;
        if (this.isSeekBySection && this.triggerSeekBySection) {
            float half = this.mSectionValue / 2.0f;
            if (this.isTouchToSeek) {
                if (progress == this.mMin || progress == this.mMax) {
                    return progress;
                }
                for (int i = 0; i <= this.mSectionCount; ++i) {
                    float secValue = (float)i * this.mSectionValue;
                    if (!(secValue < progress) || !(secValue + this.mSectionValue >= progress)) continue;
                    if (secValue + half > progress) {
                        return secValue;
                    }
                    return secValue + this.mSectionValue;
                }
            }
            if (progress >= this.mPreSecValue) {
                if (progress >= this.mPreSecValue + half) {
                    this.mPreSecValue += this.mSectionValue;
                    return this.mPreSecValue;
                }
                return this.mPreSecValue;
            }
            if (progress >= this.mPreSecValue - half) {
                return this.mPreSecValue;
            }
            this.mPreSecValue -= this.mSectionValue;
            return this.mPreSecValue;
        }
        return progress;
    }

    public OnProgressChangedListener getOnProgressChangedListener() {
        return this.mProgressListener;
    }

    public void setOnProgressChangedListener(OnProgressChangedListener onProgressChangedListener) {
        this.mProgressListener = onProgressChangedListener;
    }

    public void setTrackColor(@ColorInt int trackColor) {
        if (this.mTrackColor != trackColor) {
            this.mTrackColor = trackColor;
            this.invalidate();
        }
    }

    public void setSecondTrackColor(@ColorInt int secondTrackColor) {
        if (this.mSecondTrackColor != secondTrackColor) {
            this.mSecondTrackColor = secondTrackColor;
            this.invalidate();
        }
    }

    public void setThumbColor(@ColorInt int thumbColor) {
        if (this.mThumbColor != thumbColor) {
            this.mThumbColor = thumbColor;
            this.invalidate();
        }
    }

    public void setBubbleColor(@ColorInt int bubbleColor) {
        if (this.mBubbleColor != bubbleColor) {
            this.mBubbleColor = bubbleColor;
            if (this.mBubbleView != null) {
                this.mBubbleView.invalidate();
            }
        }
    }

    public void setCustomSectionTextArray(@NonNull CustomSectionTextArray customSectionTextArray) {
        this.mSectionTextArray = customSectionTextArray.onCustomize(this.mSectionCount, this.mSectionTextArray);
        for (int i = 0; i <= this.mSectionCount; ++i) {
            if (this.mSectionTextArray.get(i) != null) continue;
            this.mSectionTextArray.put(i, (Object)"");
        }
        this.isShowThumbText = false;
        this.requestLayout();
        this.invalidate();
    }

    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("save_instance", super.onSaveInstanceState());
        bundle.putFloat("progress", this.mProgress);
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.mProgress = bundle.getFloat("progress");
            super.onRestoreInstanceState(bundle.getParcelable("save_instance"));
            if (this.mBubbleView != null) {
                this.mBubbleView.setProgressText(this.isShowProgressInFloat ? String.valueOf(this.getProgressFloat()) : String.valueOf(this.getProgress()));
            }
            this.setProgress(this.mProgress);
            return;
        }
        super.onRestoreInstanceState(state);
    }

    private class BubbleView
    extends View {
        private Paint mBubblePaint;
        private Path mBubblePath;
        private RectF mBubbleRectF;
        private Rect mRect;
        private String mProgressText;

        BubbleView(Context context) {
            this(context, null);
        }

        BubbleView(Context context, AttributeSet attrs) {
            this(context, attrs, 0);
        }

        BubbleView(Context context, AttributeSet attrs, int defStyleAttr) {
            super(context, attrs, defStyleAttr);
            this.mProgressText = "";
            this.mBubblePaint = new Paint();
            this.mBubblePaint.setAntiAlias(true);
            this.mBubblePaint.setTextAlign(Paint.Align.CENTER);
            this.mBubblePath = new Path();
            this.mBubbleRectF = new RectF();
            this.mRect = new Rect();
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            this.setMeasuredDimension(3 * BubbleSeekBar.this.mBubbleRadius, 3 * BubbleSeekBar.this.mBubbleRadius);
            this.mBubbleRectF.set((float)this.getMeasuredWidth() / 2.0f - (float)BubbleSeekBar.this.mBubbleRadius, 0.0f, (float)this.getMeasuredWidth() / 2.0f + (float)BubbleSeekBar.this.mBubbleRadius, (float)(2 * BubbleSeekBar.this.mBubbleRadius));
        }

        protected void onDraw(Canvas canvas) {
            super.onDraw(canvas);
            this.mBubblePath.reset();
            float x0 = (float)this.getMeasuredWidth() / 2.0f;
            float y0 = (float)this.getMeasuredHeight() - (float)BubbleSeekBar.this.mBubbleRadius / 3.0f;
            this.mBubblePath.moveTo(x0, y0);
            float x1 = (float)((double)((float)this.getMeasuredWidth() / 2.0f) - Math.sqrt(3.0) / 2.0 * (double)BubbleSeekBar.this.mBubbleRadius);
            float y1 = 1.5f * (float)BubbleSeekBar.this.mBubbleRadius;
            this.mBubblePath.quadTo(x1 - (float)BubbleUtils.dp2px(2), y1 - (float)BubbleUtils.dp2px(2), x1, y1);
            this.mBubblePath.arcTo(this.mBubbleRectF, 150.0f, 240.0f);
            float x2 = (float)((double)((float)this.getMeasuredWidth() / 2.0f) + Math.sqrt(3.0) / 2.0 * (double)BubbleSeekBar.this.mBubbleRadius);
            this.mBubblePath.quadTo(x2 + (float)BubbleUtils.dp2px(2), y1 - (float)BubbleUtils.dp2px(2), x0, y0);
            this.mBubblePath.close();
            this.mBubblePaint.setColor(BubbleSeekBar.this.mBubbleColor);
            canvas.drawPath(this.mBubblePath, this.mBubblePaint);
            this.mBubblePaint.setTextSize((float)BubbleSeekBar.this.mBubbleTextSize);
            this.mBubblePaint.setColor(BubbleSeekBar.this.mBubbleTextColor);
            this.mBubblePaint.getTextBounds(this.mProgressText, 0, this.mProgressText.length(), this.mRect);
            Paint.FontMetrics fm = this.mBubblePaint.getFontMetrics();
            float baseline = (float)BubbleSeekBar.this.mBubbleRadius + (fm.descent - fm.ascent) / 2.0f - fm.descent;
            canvas.drawText(this.mProgressText, (float)this.getMeasuredWidth() / 2.0f, baseline, this.mBubblePaint);
        }

        void setProgressText(String progressText) {
            if (progressText != null && !this.mProgressText.equals(progressText)) {
                this.mProgressText = progressText;
                this.invalidate();
            }
        }
    }

    public static interface CustomSectionTextArray {
        @NonNull
        public SparseArray<String> onCustomize(int var1, @NonNull SparseArray<String> var2);
    }

    public static abstract class OnProgressChangedListenerAdapter
    implements OnProgressChangedListener {
        @Override
        public void onProgressChanged(BubbleSeekBar bubbleSeekBar, int progress, float progressFloat) {
        }

        @Override
        public void getProgressOnActionUp(BubbleSeekBar bubbleSeekBar, int progress, float progressFloat) {
        }

        @Override
        public void getProgressOnFinally(BubbleSeekBar bubbleSeekBar, int progress, float progressFloat) {
        }
    }

    public static interface OnProgressChangedListener {
        public void onProgressChanged(BubbleSeekBar var1, int var2, float var3);

        public void getProgressOnActionUp(BubbleSeekBar var1, int var2, float var3);

        public void getProgressOnFinally(BubbleSeekBar var1, int var2, float var3);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TextPosition {
        public static final int SIDES = 0;
        public static final int BOTTOM_SIDES = 1;
        public static final int BELOW_SECTION_MARK = 2;
    }
}

