/*
 * Decompiled with CFR 0.152.
 */
package com.xujl.task;

import com.xujl.task.Emitter;
import com.xujl.task.Task;

public class RxHelper {

    public static abstract class RecycleTask
    extends Task {
        private long space;
        private int maxCount;

        public RecycleTask(boolean needCancel, long space, int maxCount) {
            super(needCancel);
            this.space = space;
            this.maxCount = maxCount;
        }

        public RecycleTask(long space, int maxCount) {
            this.space = space;
            this.maxCount = maxCount;
        }

        @Override
        public void run(Emitter emitter) throws Exception {
            for (int count = 1; !(this.maxCount != -1 && count > this.maxCount || this.isDestroy()); ++count) {
                Thread.sleep(this.space);
                emitter.next(count);
            }
        }

        @Override
        public void onNext(Object object) {
            super.onNext(object);
            this.count((Integer)object);
        }

        public abstract void count(int var1);
    }

    public static abstract class CountDownTask
    extends Task {
        private long mils;
        private long space;

        public CountDownTask(long mils, long space) {
            this.mils = mils;
            this.space = space;
        }

        public CountDownTask(boolean needCancel, long mils, long space) {
            super(needCancel);
            this.mils = mils;
            this.space = space;
        }

        @Override
        public void run(Emitter emitter) throws Exception {
            long count = this.mils;
            while (count > 0L) {
                Thread.sleep(this.space);
                emitter.next(count -= this.space);
            }
        }

        @Override
        public void onNext(Object object) {
            super.onNext(object);
            this.count((Long)object);
        }

        public abstract void count(long var1);
    }
}

