/*
 * Decompiled with CFR 0.152.
 */
package com.xujichang.crashlog;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.reflect.Method;
import org.json.JSONException;
import org.json.JSONObject;

public class DeviceUtils {
    private static DeviceUtils deviceUtils = null;
    private static TelephonyManager manager;

    private DeviceUtils() {
    }

    static DeviceUtils newInstance() {
        if (deviceUtils == null) {
            deviceUtils = new DeviceUtils();
        }
        return deviceUtils;
    }

    String getDeviceInfo(Context context, JSONObject info) throws JSONException {
        manager = (TelephonyManager)context.getSystemService("phone");
        info.put("deviceid", (Object)this.getDeviceId());
        StringBuilder builder = new StringBuilder(this.getNetInfo(context));
        builder.append("\nDevice Info:");
        builder.append("cpu_name:").append(this.getCpuName()).append("   \n\u8bbe\u5907ID:").append(this.getDeviceId()).append("   \n\u624b\u673a\u54c1\u724c:").append(this.getPhoneBrand()).append("   \n\u624b\u673a\u578b\u53f7:").append(this.getPhoneModel()).append("   \nAndroid API\u7b49\u7ea7:").append(this.getBuildLevel()).append("   \nAndroid \u7248\u672c:").append(this.getBuildVersion()).append("   \n\u7cfb\u7edf\u7248\u672c\u663e\u793a\uff1a").append(this.getOsDisplay()).append("   \nHardWare:").append(this.getHardWare()).append("   \nRom\u5382\u5546:").append(this.getRom()).append("   \nmac\u5730\u5740:").append(this.getMac()).append("   \n\u8bbe\u5907\u5e8f\u5217\u53f7: ").append(this.getSerialNumber()).append("   \n\u8f6f\u4ef6\u7248\u672c:").append(this.getDeviceSoftwareVersion()).append("   \n\u56fd\u9645\u79fb\u52a8\u7528\u6237\u8bc6\u522b\u7801:").append(this.getSubscriberId()).append("   \n\u79fb\u52a8\u8fd0\u8425\u5546:").append(manager.getSimOperatorName()).append("   \nSIM\u5361\u8bc6\u522b\u7801:").append(manager.getSimSerialNumber()).append("   \nSIM\u5361\u72b6\u6001:").append(this.getSimState());
        return builder.toString();
    }

    private String getSimState() {
        String state = "\u672a\u83b7\u5f97\u72b6\u6001";
        switch (manager.getSimState()) {
            case 0: {
                state = "\u672a\u83b7\u5f97\u72b6\u6001";
                break;
            }
            case 1: {
                state = "SIM\u5361\u4e0d\u53ef\u7528";
                break;
            }
            case 2: {
                state = "Locked: requires the user's SIM PIN to unlock";
                break;
            }
            case 3: {
                state = "Locked: requires the user's SIM PUK to unlock ";
                break;
            }
            case 4: {
                state = "Locked: requires a network PIN to unlock";
                break;
            }
            case 5: {
                state = "\u6b63\u5e38";
            }
        }
        return state;
    }

    private String getRom() {
        return Build.MANUFACTURER;
    }

    private String getHardWare() {
        return Build.HARDWARE;
    }

    private String getOsDisplay() {
        return Build.DISPLAY;
    }

    private String getCpuName() {
        try {
            FileReader fr = new FileReader("/proc/cpuinfo");
            BufferedReader br = new BufferedReader(fr);
            String text = br.readLine();
            String[] array = text.split(":\\s+", 2);
            for (int i = 0; i < array.length; ++i) {
            }
            return array[1];
        }
        catch (FileNotFoundException var6) {
            var6.printStackTrace();
        }
        catch (IOException var7) {
            var7.printStackTrace();
        }
        return null;
    }

    private String getDeviceId() {
        String deviceId = manager.getDeviceId();
        return deviceId == null ? "" : deviceId;
    }

    private String getPhoneBrand() {
        return Build.BRAND;
    }

    private String getPhoneModel() {
        return Build.MODEL;
    }

    private int getBuildLevel() {
        return Build.VERSION.SDK_INT;
    }

    private String getBuildVersion() {
        return Build.VERSION.RELEASE;
    }

    private String getMac() {
        String macSerial = "";
        String str = "";
        try {
            Process pp = Runtime.getRuntime().exec("cat /sys/class/net/wlan0/address ");
            InputStreamReader ir = new InputStreamReader(pp.getInputStream());
            LineNumberReader input = new LineNumberReader(ir);
            while (null != str) {
                str = input.readLine();
                if (str == null) continue;
                macSerial = str.trim();
                break;
            }
        }
        catch (IOException var6) {
            var6.printStackTrace();
        }
        if (TextUtils.isEmpty((CharSequence)macSerial)) {
            macSerial = "\u4e0d\u53ef\u7528";
        }
        return macSerial;
    }

    private String getSerialNumber() {
        String serial = null;
        try {
            Class<?> c = Class.forName("android.os.SystemProperties");
            Method get = c.getMethod("get", String.class);
            serial = (String)get.invoke(c, "ro.serialno");
        }
        catch (Exception var4) {
            var4.printStackTrace();
        }
        return serial;
    }

    private String getDeviceSoftwareVersion() {
        return manager.getDeviceSoftwareVersion();
    }

    private String getSubscriberId() {
        return manager.getSubscriberId();
    }

    private String getNetInfo(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (null == connectivityManager) {
            return null;
        }
        StringBuilder builder = new StringBuilder("NetInfo:");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (null != networkInfo) {
            switch (networkInfo.getType()) {
                case 0: {
                    builder.append("\u4e0a\u7f51\u65b9\u5f0f\uff1a\u79fb\u52a8\u7f51\u7edc(").append(networkInfo.getSubtypeName()).append(")");
                    break;
                }
                case 1: {
                    builder.append("\u4e0a\u7f51\u65b9\u5f0f\uff1aWIFI");
                    WifiManager manager = (WifiManager)context.getSystemService("wifi");
                    builder.append("(\u72b6\u6001\uff1a" + this.transWifiState(manager.getWifiState()));
                    WifiInfo wifiInfo = manager.getConnectionInfo();
                    builder.append(" SSID:").append(wifiInfo.getSSID()).append(")");
                    break;
                }
                case 7: {
                    builder.append("\u4e0a\u7f51\u65b9\u5f0f\uff1aBlueTooth");
                    networkInfo.getSubtypeName();
                }
            }
        } else {
            builder.append("\u672a\u8fde\u63a5\u4e92\u8054\u7f51");
        }
        return builder.toString();
    }

    private String transWifiState(int wifiState) {
        String state = "unknown";
        switch (wifiState) {
            case 0: {
                state = "disabling";
                break;
            }
            case 1: {
                state = "disabled";
                break;
            }
            case 2: {
                state = "enabling";
                break;
            }
            case 3: {
                state = "enabled";
                break;
            }
            case 4: {
                state = "unknown";
            }
        }
        return state;
    }
}

