/*
 * Decompiled with CFR 0.152.
 */
package com.xujichang.crashlog;

import android.app.ActivityManager;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.os.Build;
import android.os.Debug;
import android.os.Looper;
import android.os.Process;
import android.widget.Toast;
import com.xujichang.crashlog.DeviceUtils;
import com.xujichang.crashlog.LogManager;
import com.xujichang.crashlog.LogUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class CrashHandler
implements Thread.UncaughtExceptionHandler {
    private static CrashHandler handler = null;
    private Context context;
    private Thread.UncaughtExceptionHandler defaultHandler;
    private JSONObject errInfo;
    private Class restartActivity;
    private String url;
    private LogManager logManager;
    private LogUtils logUtils;
    private RestartListener listener;

    private CrashHandler() {
    }

    public static CrashHandler newInstance() {
        if (null == handler) {
            handler = new CrashHandler();
        }
        return handler;
    }

    public void init(Context context, String url, Class restartActivity, boolean isDeBug) {
        this.context = context.getApplicationContext();
        this.restartActivity = restartActivity;
        this.url = url;
        this.errInfo = new JSONObject();
        this.logUtils = LogUtils.getInstance();
        this.logManager = LogManager.newInstance(context);
        this.logManager.setIsDeBug(isDeBug);
        this.logUtils.setIsDeBug(isDeBug);
        this.defaultHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(this);
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (null == connectivityManager.getActiveNetworkInfo()) {
            this.logUtils.logI("----------------------\u7f51\u7edc\u4e0d\u53ef\u7528", "CrashHandler");
        } else {
            this.logManager.checkLog();
        }
    }

    public void init(Context context, String url, boolean isDeBug) {
        this.init(context, url, null, isDeBug);
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        if (!this.handleException(e) && null != this.defaultHandler) {
            this.defaultHandler.uncaughtException(t, e);
        } else {
            new Thread(){

                @Override
                public void run() {
                    Looper.prepare();
                    Toast.makeText((Context)CrashHandler.this.context, (CharSequence)"\u5f88\u62b1\u6b49,\u7a0b\u5e8f\u51fa\u73b0\u5f02\u5e38,\u5373\u5c06\u9000\u51fa.", (int)0).show();
                    Looper.loop();
                }
            }.start();
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException var4) {
                var4.printStackTrace();
            }
            this.restartApp();
        }
    }

    private boolean handleException(Throwable e) {
        this.logUtils.logI("----------------------------------------\u5904\u7406Exception\uff1a", "CrashHandler");
        if (null == e) {
            return false;
        }
        try {
            this.getDeviceInfo();
            this.getExceptionInfo(e);
            this.logManager.saveExceptionLog(this.errInfo.toString());
            return true;
        }
        catch (JSONException var3) {
            var3.printStackTrace();
            return false;
        }
    }

    private void restartApp() {
        this.logUtils.logI("----------------------------------------\u91cd\u542fAPP\uff1a", "CrashHandler");
        if (null != this.listener) {
            this.listener.restart();
        }
        if (null != this.restartActivity) {
            AlarmManager mgr = (AlarmManager)this.context.getSystemService("alarm");
            Intent intent = new Intent(this.context, this.restartActivity);
            intent.setFlags(0x10000000);
            PendingIntent restartIntent = PendingIntent.getActivity((Context)this.context, (int)0, (Intent)intent, (int)0x40000000);
            mgr.set(1, System.currentTimeMillis() + 500L, restartIntent);
        }
        Process.killProcess((int)Process.myPid());
        System.exit(0);
        System.gc();
    }

    private void getExceptionInfo(Throwable e) throws JSONException {
        StringBuilder builder = new StringBuilder("App Version:").append(this.getVersion()).append("\n");
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        e.printStackTrace(printWriter);
        for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
            cause.printStackTrace(printWriter);
        }
        printWriter.close();
        String result = ((Object)writer).toString();
        builder.append("\tErrorInfo:\n").append(result);
        String str = this.errInfo.optString("content");
        builder.append(str, 0, str.length());
        this.errInfo.put("content", (Object)builder.toString());
        this.logUtils.logI("----------------------------------------\u83b7\u53d6\u9519\u8bef\u4fe1\u606f\uff1a" + builder.toString(), "CrashHandler");
    }

    private void getDeviceInfo() throws JSONException {
        String deviceInfo = DeviceUtils.newInstance().getDeviceInfo(this.context, this.errInfo);
        StringBuilder builder = new StringBuilder(deviceInfo);
        this.errInfo.put("content", (Object)builder.append("\n").toString());
        this.logUtils.logI("----------------------------------------\u83b7\u53d6\u8bbe\u5907\u4fe1\u606f\uff1a" + deviceInfo, "CrashHandler");
    }

    String getUrl() {
        return this.url;
    }

    public void setOnRestartListener(RestartListener listener) {
        this.listener = listener;
    }

    private String getVersion() {
        this.getRunningInfo();
        String versionName = "\u7248\u672c\u672a\u77e5";
        String packageName = "\u5305\u540d\u672a\u77e5";
        try {
            PackageManager manager = this.context.getPackageManager();
            PackageInfo info = manager.getPackageInfo(this.context.getPackageName(), 0);
            versionName = info.versionName;
            packageName = this.context.getPackageName();
        }
        catch (Exception e) {
            e.printStackTrace();
            return versionName + "   " + packageName;
        }
        return versionName + "   " + packageName;
    }

    private void getRunningInfo() {
        StringBuilder builder = new StringBuilder("Activity\u8fd0\u884c\u4fe1\u606f:\n");
        ActivityManager activityManager = (ActivityManager)this.context.getSystemService("activity");
        activityManager.getMemoryClass();
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        activityManager.getMemoryInfo(memoryInfo);
        builder.append("\u5728\u4f4e\u5185\u5b58\u4e0b\u8fd0\u884c\uff1a").append(memoryInfo.lowMemory).append("\n");
        builder.append("\u603b\u5185\u5b58\uff1a").append(memoryInfo.totalMem).append("\n");
        builder.append("\u53ef\u7528\u5185\u5b58\uff1a").append(memoryInfo.availMem).append("\n");
        Debug.MemoryInfo debugInfo = new Debug.MemoryInfo();
        Debug.getMemoryInfo((Debug.MemoryInfo)debugInfo);
        builder.append("\u5728\u4f4e\u5185\u5b58\u4e0b\u8fd0\u884c\uff1a").append(debugInfo.dalvikPss).append("\n");
        builder.append("\u5728\u4f4e\u5185\u5b58\u4e0b\u8fd0\u884c\uff1a").append(memoryInfo.threshold).append("\n");
        builder.append("\u5728\u4f4e\u5185\u5b58\u4e0b\u8fd0\u884c\uff1a").append(memoryInfo.lowMemory).append("\n");
        builder.append("Activity\u4fe1\u606f\uff1a\n");
        if (Build.VERSION.SDK_INT >= 23) {
            builder.append("M is for Marshmallow!\n");
            List appTasks = activityManager.getAppTasks();
            ActivityManager.RecentTaskInfo appTaskInfo = ((ActivityManager.AppTask)appTasks.get(0)).getTaskInfo();
            builder.append("TopActivity\uff1a").append(appTaskInfo.topActivity.getClassName()).append("\n");
            builder.append("BaseActivity\uff1a").append(appTaskInfo.baseActivity.getClassName()).append("\n");
            builder.append("origActivity\uff1a").append(appTaskInfo.origActivity.getClassName()).append("\n");
            builder.append("Activity\u603b\u6570\u91cf\uff1a").append(appTaskInfo.numActivities).append("\n");
        } else if (Build.VERSION.SDK_INT >= 21) {
            builder.append("L is for Lollipop!\n");
            ActivityManager.RunningAppProcessInfo info = (ActivityManager.RunningAppProcessInfo)activityManager.getRunningAppProcesses().get(0);
            builder.append("importanceReasonComponent\uff1a").append(info.importanceReasonComponent).append("\n");
            builder.append("processName\uff1a").append(info.processName).append("\n");
            builder.append("pkgList\uff1a").append(Arrays.asList(info.pkgList).toString()).append("\n");
        } else {
            builder.append("blow  Lollipop!\n");
            List runningTaskInfoes = activityManager.getRunningTasks(1);
            ActivityManager.RunningTaskInfo runningTaskInfo = (ActivityManager.RunningTaskInfo)runningTaskInfoes.get(0);
            builder.append("TopActivity\uff1a").append(runningTaskInfo.topActivity.getClassName()).append("\n");
            builder.append("BaseActivity\uff1a").append(runningTaskInfo.baseActivity.getClassName()).append("\n");
            builder.append("Activity\u603b\u6570\u91cf\uff1a").append(runningTaskInfo.numActivities).append("\n");
            builder.append("\u6b63\u5728\u8fd0\u884c\u7684Activity\u6570\uff1a").append(runningTaskInfo.numRunning).append("\n");
        }
        this.logUtils.logI("----------------------------------------\u83b7\u53d6Activity\u8fd0\u884c\u4fe1\u606f\uff1a" + builder.toString(), "CrashHandler");
    }

    public static interface RestartListener {
        public void restart();
    }
}

