package com.xujichang.crashlog;

import android.app.ActivityManager;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.os.Build;
import android.os.Debug;
import android.os.Looper;
import android.os.Process;
import android.widget.Toast;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by user on 2017/3/29.
 */


public class CrashHandler implements Thread.UncaughtExceptionHandler {

  private static CrashHandler handler = null;
  private Context context;
  private Thread.UncaughtExceptionHandler defaultHandler;
  private JSONObject errInfo;
  private Class restartActivity;
  private String url;
  private LogManager logManager;
  private LogUtils logUtils;
  private CrashHandler.RestartListener listener;

  private CrashHandler() {
  }

  public static CrashHandler newInstance() {
    if (null == handler) {
      handler = new CrashHandler();
    }

    return handler;
  }

  public void init(Context context, String url, Class restartActivity, boolean isDeBug) {
    this.context = context.getApplicationContext();
    this.restartActivity = restartActivity;
    this.url = url;
    this.errInfo = new JSONObject();
    this.logUtils = LogUtils.getInstance();
    this.logManager = LogManager.newInstance(context);
    this.logManager.setIsDeBug(isDeBug);
    this.logUtils.setIsDeBug(isDeBug);
    this.defaultHandler = Thread.getDefaultUncaughtExceptionHandler();
    Thread.setDefaultUncaughtExceptionHandler(this);
    ConnectivityManager connectivityManager = (ConnectivityManager) context
        .getSystemService(Context.CONNECTIVITY_SERVICE);
    if (null == connectivityManager.getActiveNetworkInfo()) {
      this.logUtils.logI("----------------------网络不可用", "CrashHandler");
    } else {
      this.logManager.checkLog();
    }
//        if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.LOLLIPOP) {
//            //申请权限
//            Intent intent = null;
//            intent = new Intent(Settings.ACTION_USAGE_ACCESS_SETTINGS);
//            context.startActivity(intent);
//        }
  }

  public void init(Context context, String url, boolean isDeBug) {
    this.init(context, url, (Class) null, isDeBug);
  }
//
//    private void getLogFromServer() {
//        this.logUtils.logI("----------------------查询服务器Log", "CrashHandler");
//        HttpURLConnection connection = null;
//        Object var2 = null;
//
//        try {
//            URL realUrl = new URL(this.url);
//            connection = (HttpURLConnection) realUrl.openConnection();
//            connection.connect();
//            int response = connection.getResponseCode();
//            if (response == 200) {
//                InputStream is = connection.getInputStream();
//                StringBuffer out = new StringBuffer();
//                byte[] b = new byte[4096];
//
//                int n;
//                while ((n = is.read(b)) != -1) {
//                    out.append(new String(b, 0, n));
//                }
//
//                this.logUtils.logI("---------------------服务器Log：" + out.toString(), "CrashHandler");
//            } else {
//                this.logUtils.logI("----------------------查询失败：" + response, "CrashHandler");
//            }
//        } catch (IOException var12) {
//            var12.printStackTrace();
//        } finally {
//            if (null != connection) {
//                connection.disconnect();
//            }
//
//        }
//
//    }

  public void uncaughtException(Thread t, Throwable e) {
    if (!this.handleException(e) && null != this.defaultHandler) {
      this.defaultHandler.uncaughtException(t, e);
    } else {
      (new Thread() {
        public void run() {
          Looper.prepare();
          Toast.makeText(CrashHandler.this.context, "很抱歉,程序出现异常,即将退出.", Toast.LENGTH_SHORT).show();
          Looper.loop();
        }
      }).start();

      try {
        Thread.sleep(2000L);
      } catch (InterruptedException var4) {
        var4.printStackTrace();
      }

      this.restartApp();
    }

  }

  private boolean handleException(Throwable e) {
    this.logUtils.logI("----------------------------------------处理Exception：", "CrashHandler");
    if (null == e) {
      return false;
    } else {
      try {
        this.getDeviceInfo();
        this.getExceptionInfo(e);
        this.logManager.saveExceptionLog(this.errInfo.toString());
        return true;
      } catch (JSONException var3) {
        var3.printStackTrace();
        return false;
      }
    }
  }

  private void restartApp() {
    this.logUtils.logI("----------------------------------------重启APP：", "CrashHandler");
    if (null != this.listener) {
      this.listener.restart();
    }

    if (null != this.restartActivity) {
      AlarmManager mgr = (AlarmManager) this.context.getSystemService(Context.ALARM_SERVICE);
      Intent intent = new Intent(this.context, this.restartActivity);
      intent.setFlags(268435456);
      PendingIntent restartIntent = PendingIntent
          .getActivity(this.context, 0, intent, PendingIntent.FLAG_ONE_SHOT);
      mgr.set(1, System.currentTimeMillis() + 500L, restartIntent);
    }

    Process.killProcess(Process.myPid());
    System.exit(0);
    System.gc();
  }

  private void getExceptionInfo(Throwable e) throws JSONException {

    StringBuilder builder = new StringBuilder("App Version:").append(getVersion()).append("\n");

//        StackTraceElement[] var3 = e.getStackTrace();
//        int var4 = var3.length;
//
//        for (int var5 = 0; var5 < var4; ++var5) {
//            StackTraceElement traceElement = var3[var5];
//            builder.append("\tat ").append(traceElement).append("\n");
//        }
    Writer writer = new StringWriter();
    PrintWriter printWriter = new PrintWriter(writer);
    e.printStackTrace(printWriter);
    Throwable cause = e.getCause();
    while (cause != null) {
      cause.printStackTrace(printWriter);
      cause = cause.getCause();
    }
    printWriter.close();
    String result = writer.toString();
    builder.append("\tErrorInfo:\n").append(result);
    String str = errInfo.optString("content");
    builder.append(str, 0, str.length());
    errInfo.put("content", builder.toString());
    logUtils.logI("----------------------------------------获取错误信息：" + builder.toString(),
        "CrashHandler");
  }

  private void getDeviceInfo() throws JSONException {
    String deviceInfo = DeviceUtils.newInstance().getDeviceInfo(this.context, this.errInfo);
    StringBuilder builder = new StringBuilder(deviceInfo);
    errInfo.put("content", builder.append("\n").toString());
    logUtils.logI("----------------------------------------获取设备信息：" + deviceInfo, "CrashHandler");
  }

  String getUrl() {
    return this.url;
  }

  public void setOnRestartListener(CrashHandler.RestartListener listener) {
    this.listener = listener;
  }

  public interface RestartListener {

    void restart();
  }

  /**
   * 获取版本号
   *
   * @return 当前应用的版本号
   */
  private String getVersion() {
    //暂时作为测试，需要真机测试，所以并未放到日志
    getRunningInfo();
    String versionName = "版本未知";
    String packageName = "包名未知";
    try {
      PackageManager manager = context.getPackageManager();
      PackageInfo info = manager.getPackageInfo(context.getPackageName(), 0);
      versionName = info.versionName;
      packageName = context.getPackageName();
    } catch (Exception e) {
      e.printStackTrace();
      return versionName + "   " + packageName;
    }
    return versionName + "   " + packageName;
  }

  private void getRunningInfo() {
    StringBuilder builder = new StringBuilder("Activity运行信息:\n");
    ActivityManager activityManager = (ActivityManager) context
        .getSystemService(Context.ACTIVITY_SERVICE);
    activityManager.getMemoryClass();
    ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
    activityManager.getMemoryInfo(memoryInfo);
    builder.append("在低内存下运行：").append(memoryInfo.lowMemory).append("\n");
    builder.append("总内存：").append(memoryInfo.totalMem).append("\n");
    builder.append("可用内存：").append(memoryInfo.availMem).append("\n");

    Debug.MemoryInfo debugInfo = new Debug.MemoryInfo();
    Debug.getMemoryInfo(debugInfo);
    builder.append("在低内存下运行：").append(debugInfo.dalvikPss).append("\n");
    builder.append("在低内存下运行：").append(memoryInfo.threshold).append("\n");
    builder.append("在低内存下运行：").append(memoryInfo.lowMemory).append("\n");
    builder.append("Activity信息：\n");
    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
      //6.0
      builder.append("M is for Marshmallow!\n");
      List<ActivityManager.AppTask> appTasks = activityManager.getAppTasks();
      ActivityManager.RecentTaskInfo appTaskInfo = appTasks.get(0).getTaskInfo();
      builder.append("TopActivity：").append(appTaskInfo.topActivity.getClassName()).append("\n");
      builder.append("BaseActivity：").append(appTaskInfo.baseActivity.getClassName()).append("\n");
      builder.append("origActivity：").append(appTaskInfo.origActivity.getClassName()).append("\n");
      builder.append("Activity总数量：").append(appTaskInfo.numActivities).append("\n");
    } else if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
      //5.0
      builder.append("L is for Lollipop!\n");
      ActivityManager.RunningAppProcessInfo info = activityManager.getRunningAppProcesses().get(0);
      builder.append("importanceReasonComponent：").append(info.importanceReasonComponent)
          .append("\n");
      builder.append("processName：").append(info.processName).append("\n");
      builder.append("pkgList：").append(Arrays.asList(info.pkgList).toString()).append("\n");
    } else {
      //
      builder.append("blow  Lollipop!\n");
      List<ActivityManager.RunningTaskInfo> runningTaskInfoes = activityManager.getRunningTasks(1);
      ActivityManager.RunningTaskInfo runningTaskInfo = runningTaskInfoes.get(0);
      builder.append("TopActivity：").append(runningTaskInfo.topActivity.getClassName())
          .append("\n");
      builder.append("BaseActivity：").append(runningTaskInfo.baseActivity.getClassName())
          .append("\n");
      builder.append("Activity总数量：").append(runningTaskInfo.numActivities).append("\n");
      builder.append("正在运行的Activity数：").append(runningTaskInfo.numRunning).append("\n");
    }
    this.logUtils
        .logI("----------------------------------------获取Activity运行信息：" + builder.toString(),
            "CrashHandler");
  }
}