/*
 * Decompiled with CFR 0.152.
 */
package com.xtivia.sgdxp.filter;

import com.liferay.portal.kernel.model.User;
import com.xtivia.sgdxp.annotation.Authorized;
import com.xtivia.sgdxp.core.IAuthorizer;
import com.xtivia.sgdxp.core.SgDxpApplication;
import com.xtivia.sgdxp.filter.AbstractSecurityFilter;
import com.xtivia.sgdxp.liferay.DxpResourceContext;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Authorized
public class AuthorizedFilter
extends AbstractSecurityFilter {
    private static Logger _logger = LoggerFactory.getLogger(AuthorizedFilter.class);

    public AuthorizedFilter(SgDxpApplication xsfApplication) {
        super(xsfApplication);
    }

    @Override
    public void filter(ContainerRequestContext requestContext) {
        ResourceInfo resourceInfo;
        if (_logger.isDebugEnabled()) {
            resourceInfo = super.getResourceInfo();
            _logger.debug(String.format("Authorized filter executes for class=%s, method=%s", resourceInfo.getResourceClass().getName(), resourceInfo.getResourceMethod().getName()));
        }
        if (!this.checkIsAuthorized()) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        if (_logger.isDebugEnabled()) {
            resourceInfo = super.getResourceInfo();
            _logger.debug(String.format("Authorized filter succeeds for class=%s, method=%s", resourceInfo.getResourceClass().getName(), resourceInfo.getResourceMethod().getName()));
        }
    }

    private boolean checkIsAuthorized() {
        boolean result = true;
        Authorized annotation = (Authorized)this.getAnnotation(Authorized.class);
        if (annotation != null) {
            User user = this.getUser();
            if (user != null && !user.isDefaultUser()) {
                DxpResourceContext ctx = new DxpResourceContext(super.getRequest(), (Map)super.getUriInfo().getPathParameters(), super.getResourceInfo());
                IAuthorizer authorizer = super.getSgDxpApplication().getAuthorizer(ctx);
                if (authorizer != null) {
                    result = authorizer.authorize(ctx);
                }
            } else {
                result = false;
            }
        }
        return result;
    }
}

