/*
 * Decompiled with CFR 0.152.
 */
package com.xtivia.sgdxp.filter;

import com.liferay.portal.kernel.model.User;
import com.xtivia.sgdxp.annotation.Authenticated;
import com.xtivia.sgdxp.core.SgDxpApplication;
import com.xtivia.sgdxp.filter.AbstractSecurityFilter;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Authenticated
public class AuthenticatedFilter
extends AbstractSecurityFilter {
    private static Logger _logger = LoggerFactory.getLogger(AuthenticatedFilter.class);

    public AuthenticatedFilter(SgDxpApplication xsfApplication) {
        super(xsfApplication);
    }

    @Override
    public void filter(ContainerRequestContext requestContext) {
        ResourceInfo resourceInfo;
        if (_logger.isDebugEnabled()) {
            resourceInfo = super.getResourceInfo();
            _logger.debug(String.format("Auhenticated filter executes for class=%s, method=%s", resourceInfo.getResourceClass().getName(), resourceInfo.getResourceMethod().getName()));
        }
        if (!this.checkIsAuthenticated()) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        if (_logger.isDebugEnabled()) {
            resourceInfo = super.getResourceInfo();
            _logger.debug(String.format("Auhenticated filter succeeds for class=%s, method=%s", resourceInfo.getResourceClass().getName(), resourceInfo.getResourceMethod().getName()));
        }
    }

    private boolean checkIsAuthenticated() {
        boolean result = true;
        Authenticated annotation = (Authenticated)this.getAnnotation(Authenticated.class);
        if (annotation != null) {
            User user = this.getUser();
            result = user != null && !user.isDefaultUser();
        }
        return result;
    }
}

