/*
 * Decompiled with CFR 0.152.
 */
package com.xtivia.sgdxp.filter;

import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.xtivia.sgdxp.core.SgDxpApplication;
import java.lang.annotation.Annotation;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractSecurityFilter
implements ContainerRequestFilter {
    @Context
    private HttpServletRequest httpRequest;
    @Context
    private ResourceInfo resourceInfo;
    @Context
    private UriInfo uriInfo;
    private SgDxpApplication sgDxpApplication;
    private static Logger _logger = LoggerFactory.getLogger(AbstractSecurityFilter.class);

    AbstractSecurityFilter(SgDxpApplication sgDxpApplication) {
        this.sgDxpApplication = sgDxpApplication;
    }

    public abstract void filter(ContainerRequestContext var1);

    User getUser() {
        User user = null;
        UserLocalService userLocalService = this.getSgDxpApplication().getUserLocalService();
        String userid = this.httpRequest.getRemoteUser();
        try {
            if (userid != null && userLocalService != null && (user = userLocalService.getUser(new Long(userid).longValue())).isDefaultUser()) {
                user = null;
            }
        }
        catch (Exception e) {
            _logger.error("Error accessing DXP user service", (Throwable)e);
        }
        return user;
    }

    protected <T> T getAnnotation(Class<? extends Annotation> annotationClass) {
        Annotation annotation = this.resourceInfo.getResourceMethod().getAnnotation(annotationClass);
        if (annotation == null) {
            annotation = this.resourceInfo.getResourceClass().getAnnotation(annotationClass);
        }
        return (T)annotation;
    }

    HttpServletRequest getRequest() {
        return this.httpRequest;
    }

    ResourceInfo getResourceInfo() {
        return this.resourceInfo;
    }

    UriInfo getUriInfo() {
        return this.uriInfo;
    }

    SgDxpApplication getSgDxpApplication() {
        return this.sgDxpApplication;
    }
}

