/*
 * Decompiled with CFR 0.152.
 */
package com.xtensolution.support.utils;

import android.content.SharedPreferences;
import com.xtensolution.support.CoreApp;

public class SharedPrefsHelper {
    private static final String SHARED_PREFS_NAME = CoreApp.getInstance().getPackageName();
    private static SharedPrefsHelper instance;
    private SharedPreferences sharedPreferences;

    public static synchronized SharedPrefsHelper getInstance() {
        if (instance == null) {
            instance = new SharedPrefsHelper();
        }
        return instance;
    }

    private SharedPrefsHelper() {
        instance = this;
        this.sharedPreferences = CoreApp.getInstance().getSharedPreferences(SHARED_PREFS_NAME, 0);
    }

    public void delete(String key) {
        if (this.sharedPreferences.contains(key)) {
            this.getEditor().remove(key).commit();
        }
    }

    public void save(String key, Object value) {
        SharedPreferences.Editor editor = this.getEditor();
        if (value instanceof Boolean) {
            editor.putBoolean(key, ((Boolean)value).booleanValue());
        } else if (value instanceof Integer) {
            editor.putInt(key, ((Integer)value).intValue());
        } else if (value instanceof Float) {
            editor.putFloat(key, ((Float)value).floatValue());
        } else if (value instanceof Long) {
            editor.putLong(key, ((Long)value).longValue());
        } else if (value instanceof String) {
            editor.putString(key, (String)value);
        } else if (value instanceof Enum) {
            editor.putString(key, value.toString());
        } else if (value != null) {
            throw new RuntimeException("Attempting to save non-supported preference");
        }
        editor.commit();
    }

    public <T> T get(String key) {
        return (T)this.sharedPreferences.getAll().get(key);
    }

    public <T> T get(String key, T defValue) {
        Object returnValue = this.sharedPreferences.getAll().get(key);
        return (T)(returnValue == null ? defValue : returnValue);
    }

    public boolean has(String key) {
        return this.sharedPreferences.contains(key);
    }

    private SharedPreferences.Editor getEditor() {
        return this.sharedPreferences.edit();
    }
}

