/*
 * Decompiled with CFR 0.152.
 */
package com.xtensolution.support.ui.fragment;

import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.xtensolution.support.ui.activity.CoreActionBarActivity;
import com.xtensolution.support.ui.activity.CoreBaseActivity;
import com.xtensolution.support.ui.activity.CoreDrawerActivity;
import com.xtensolution.support.ui.activity.CoreFragmentActivity;
import com.xtensolution.support.ui.listener.MenuCheckedListener;
import com.xtensolution.support.utils.AppLog;

public abstract class CoreBaseFragment
extends Fragment
implements MenuCheckedListener {
    private static final String TAG = CoreBaseFragment.class.getSimpleName();
    protected CoreBaseActivity mActivity;
    protected View mContentView;
    protected boolean mHasArrow = false;
    protected boolean mHasHamburger = true;
    protected boolean allowCurrentScreenTitle = true;
    protected OnFragmentInteractionListener mListener;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setHasOptionsMenu(true);
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.mContentView = inflater.inflate(this.getViewResourceId(), null, false);
        this.mActivity = (CoreBaseActivity)this.getActivity();
        this.setHasOptionsMenu(true);
        return this.mContentView;
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.onViewBind();
    }

    public void onResume() {
        if (this.getActivity() instanceof CoreActionBarActivity && this.allowCurrentScreenTitle) {
            CoreActionBarActivity activity = (CoreActionBarActivity)this.getActivity();
            activity.setActionBarTitle(this.getScreenTitle());
        }
        this.changeDrawerIconState();
        super.onResume();
    }

    public void setScreenTitle(String title) {
        if (this.getActivity() instanceof CoreActionBarActivity && this.allowCurrentScreenTitle) {
            CoreActionBarActivity activity = (CoreActionBarActivity)this.getActivity();
            activity.setActionBarTitle(title);
        }
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
    }

    public <T extends View> T _findViewById(int resId) {
        return (T)this.mContentView.findViewById(resId);
    }

    public abstract String getScreenTitle();

    protected abstract int getViewResourceId();

    protected abstract void onViewBind();

    private void changeDrawerIconState() {
        AppLog.d(TAG, "changeDrawerIconState: ");
        if (this.getActivity() instanceof CoreDrawerActivity) {
            CoreDrawerActivity activity = (CoreDrawerActivity)this.getActivity();
            activity.changeDrawerIndicator(this.mHasArrow, this.mHasHamburger);
        }
    }

    @Override
    public int getPageMenuId() {
        return 0;
    }

    public void replaceFragment(Fragment fragment) {
        this.mActivity.replaceFragment(fragment);
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (context instanceof OnFragmentInteractionListener) {
            this.mListener = (OnFragmentInteractionListener)context;
        }
    }

    @Override
    public boolean isHomePage() {
        return false;
    }

    public boolean isAllowCurrentScreenTitle() {
        return this.allowCurrentScreenTitle;
    }

    public void setAllowCurrentScreenTitle(boolean allowCurrentScreenTitle) {
        this.allowCurrentScreenTitle = allowCurrentScreenTitle;
    }

    public void onDestroy() {
        super.onDestroy();
        this.resetTitle();
    }

    public void onDetach() {
        super.onDetach();
        this.resetTitle();
    }

    private void resetTitle() {
        if (this.getActivity() instanceof CoreFragmentActivity) {
            CoreFragmentActivity fragmentActivity = (CoreFragmentActivity)this.getActivity();
            fragmentActivity.resetTitle();
        }
    }

    public static interface OnFragmentInteractionListener<T> {
        public void onFragmentInteraction(T var1);
    }
}

