/*
 * Decompiled with CFR 0.152.
 */
package com.xtensolution.support.ui.activity;

import androidx.fragment.app.Fragment;
import com.xtensolution.support.R;
import com.xtensolution.support.exceptions.FragmentContainerResourceNotFoundException;
import com.xtensolution.support.ui.activity.CoreActionBarActivity;
import com.xtensolution.support.ui.fragment.CoreBaseFragment;
import com.xtensolution.support.ui.listener.MenuCheckedListener;
import com.xtensolution.support.utils.AppLog;
import com.xtensolution.support.utils.ResourceUtils;

public abstract class CoreFragmentActivity
extends CoreActionBarActivity
implements MenuCheckedListener {
    private static final String TAG = CoreFragmentActivity.class.getSimpleName();
    protected Fragment currentLoadedFragment;

    @Override
    public void replaceFragment(Fragment fragment) {
        try {
            CoreBaseFragment baseFragment;
            if (fragment instanceof CoreBaseFragment && (baseFragment = (CoreBaseFragment)fragment).isHomePage()) {
                this.onBackPressed();
                return;
            }
            if (this.getFragmentContainer() != 0) {
                this.currentLoadedFragment = this.getSupportFragmentManager().findFragmentById(this.getFragmentContainer());
                if (this.currentLoadedFragment != null && this.currentLoadedFragment.getTag() != null) {
                    String tag = fragment.getClass().getSimpleName();
                    if (this.currentLoadedFragment.getTag().equalsIgnoreCase(tag)) {
                        return;
                    }
                }
            } else {
                throw new FragmentContainerResourceNotFoundException(ResourceUtils.getString(R.string.no_fragment_container_found));
            }
            super.replaceFragment(fragment);
        }
        catch (Exception e) {
            AppLog.e(TAG, e.getMessage(), e);
        }
    }

    @Override
    public int getPageMenuId() {
        return 0;
    }

    @Override
    public boolean isHomePage() {
        return false;
    }

    public void resetTitle() {
        Fragment fragment;
        if (this.getFragmentContainer() != 0 && (fragment = this.getSupportFragmentManager().findFragmentById(this.getFragmentContainer())) instanceof CoreBaseFragment) {
            CoreBaseFragment baseFragment = (CoreBaseFragment)fragment;
            this.setActionBarTitle(baseFragment.getScreenTitle());
        }
    }
}

