/*
 * Decompiled with CFR 0.152.
 */
package com.xtensolution.support.ui.activity;

import android.os.Bundle;
import android.view.View;
import android.widget.ProgressBar;
import androidx.annotation.StringRes;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentTransaction;
import com.google.android.material.floatingactionbutton.FloatingActionButton;
import com.xtensolution.support.R;
import com.xtensolution.support.exceptions.FragmentContainerResourceNotFoundException;
import com.xtensolution.support.utils.AppLog;
import com.xtensolution.support.utils.ErrorUtils;
import com.xtensolution.support.utils.ResourceUtils;

public abstract class CoreBaseActivity
extends AppCompatActivity {
    private static final String TAG = CoreBaseActivity.class.getSimpleName();
    protected ProgressBar progressBar;
    protected FloatingActionButton fab;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(this.getLayout());
        if (this.getProgressBarId() != 0) {
            this.progressBar = (ProgressBar)this._findViewById(this.getProgressBarId());
        }
        if (this.getFabId() != 0) {
            this.fab = (FloatingActionButton)this._findViewById(this.getFabId());
            this.fab.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    CoreBaseActivity.this.onFabClick(view);
                }
            });
        }
        this.onContentViewBind();
    }

    protected void onFabClick(View view) {
        this.showSnackbar(R.string.fab_clicked, new View.OnClickListener(){

            public void onClick(View view) {
            }
        });
    }

    protected int getFabId() {
        return 0;
    }

    public <T extends View> T _findViewById(int viewId) {
        return (T)this.findViewById(viewId);
    }

    protected void showSnackbarError(@StringRes int resId, Exception e, View.OnClickListener clickListener) {
        ErrorUtils.showSnackbar(this.getRootView(), resId, e, R.string.dlg_retry, clickListener);
    }

    protected abstract int getLayout();

    public abstract View getRootView();

    protected abstract void onContentViewBind();

    public int getProgressBarId() {
        return 0;
    }

    public void replaceFragment(Fragment fragment) {
        try {
            if (this.getFragmentContainer() == 0) {
                throw new FragmentContainerResourceNotFoundException(ResourceUtils.getString(R.string.no_fragment_container_found));
            }
            FragmentTransaction ft = this.getSupportFragmentManager().beginTransaction();
            ft.replace(this.getFragmentContainer(), fragment, fragment.getClass().getSimpleName());
            ft.setTransition(4099);
            ft.addToBackStack(fragment.getClass().getSimpleName());
            ft.commit();
        }
        catch (Exception e) {
            AppLog.e(TAG, e.getMessage(), e);
        }
    }

    protected int getFragmentContainer() {
        return 0;
    }

    protected void changeSelectedMenu() {
    }

    public void showSnackbar(@StringRes int resId, View.OnClickListener listener) {
        ErrorUtils.showSnackbar(this.getRootView(), resId, R.string.dlg_ok, listener);
    }

    public void showSnackbar(String message) {
        ErrorUtils.showSnackbar(this.getRootView(), message, R.string.dlg_ok, new View.OnClickListener(){

            public void onClick(View v) {
            }
        });
    }
}

