/*
 * Copyright (c) 2016 riontech-xten
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.xtensolution.support.utils;

import android.os.Bundle;
import android.text.TextUtils;

import java.lang.reflect.Field;
import java.util.Set;

/**
 * Created by MIT on 8/19/2016.
 */
public class StringUtils {
    public static void printBundle(Bundle bundle) {
        if (bundle != null) {
            Set<String> set = bundle.keySet();
            System.out.print("Bundle  key => value ");
            for (String s : set) {
                System.out.print(s + " => " + bundle.get(s));
            }
        }
    }

    public static String toJson(Class clazz, Object object) {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        try {
            for (Field field : clazz.getDeclaredFields()) {
                field.setAccessible(true);
                sb.append("\"" + field.getName() + "\"").append(":")
                        .append("\"" + getFieldValue(field, object) + "\"").append(",");
            }
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        String str = sb.substring(0, sb.length() - 1);
        sb = new StringBuffer(str);
        sb.append("}");
        return sb.toString();
    }

    private static String getFieldValue(Field field, Object object) throws IllegalAccessException {
        if (field.get(object) == null)
            return "";
        return field.get(object).toString();
    }

    public static boolean isValidString(String str) {
        return str != null && !TextUtils.isEmpty(str.trim()) && str.trim().length() > 0;
    }
}
