/*
 * Copyright (c) 2016 riontech-xten
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.xtensolution.support.utils;


import com.xtensolution.support.R;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by MIT on 10-Aug-17.
 */

public class FileExtensionUtils {
    public static final String EXT_PDF = ".pdf";
    public static final String EXT_DOC = ".doc";
    public static final String EXT_DOCS = ".docs";
    public static final String EXT_XLSX = ".xlsx";
    public static final String EXT_XLS = ".xls";
    public static final String EXT_TXT = ".txt";
    public static final String EXT_JSON = ".json";
    public static final String EXT_XML = ".xml";
    public static final String EXT_ZIP = ".zip";
    public static final String EXT_CSV = ".csv";
    public static final String EXT_HTML = ".html";
    public static final String EXT_PNG = ".png";
    public static final String EXT_JPG = ".jpg";
    public static final String EXT_JPEG = ".jpeg";
    public static final String EXT_GIF = ".gif";
    public static final String EXT_MP4 = ".mp4";
    public static final String EXT_MP3 = ".mp3";
    public static final String EXT_WAV = ".wav";
//
    public static HashMap<String, Integer> getFileExtMap() {
        HashMap<String, Integer> fileMap = new HashMap<>();
        fileMap.put(EXT_CSV, R.drawable.ic_vector_ext_csv);
        fileMap.put(EXT_DOC, R.drawable.ic_vector_ext_doc);
        fileMap.put(EXT_DOCS, R.drawable.ic_vector_ext_docx);
        fileMap.put(EXT_GIF, R.drawable.ic_vector_ext_gif);
        fileMap.put(EXT_HTML, R.drawable.ic_vector_ext_html);
        fileMap.put(EXT_JPEG, R.drawable.ic_vector_ext_jpg);
        fileMap.put(EXT_JPG, R.drawable.ic_vector_ext_jpg);
        fileMap.put(EXT_JSON, R.drawable.ic_vector_ext_json);
        fileMap.put(EXT_MP3, R.drawable.ic_vector_ext_mp3);
        fileMap.put(EXT_MP4, R.drawable.ic_vector_ext_mp4);
        fileMap.put(EXT_PDF, R.drawable.ic_vector_ext_pdf);
        fileMap.put(EXT_PNG, R.drawable.ic_vector_ext_png);
        fileMap.put(EXT_TXT, R.drawable.ic_vector_ext_txt);
        fileMap.put(EXT_WAV, R.drawable.ic_vector_ext_mp4);
        fileMap.put(EXT_XLS, R.drawable.ic_vector_ext_xls);
        fileMap.put(EXT_XLSX, R.drawable.ic_vector_ext_xlsx);
        fileMap.put(EXT_XML, R.drawable.ic_vector_ext_xml);
        fileMap.put(EXT_ZIP, R.drawable.ic_vector_ext_zip);

        return fileMap;
    }
//
    public static Integer getResourceId(String extension) {
        Map<String, Integer> codeMap = getFileExtMap();
        try {
            if (codeMap.containsKey(extension))
                return codeMap.get(extension);
            else
                return 0;
        } catch (Exception e) {
            return 0;
        }
    }
}
