package com.xtensolution.support.utils;

import android.app.Activity;

import java.util.ArrayList;
import java.util.HashMap;

/**
 * Created by RIONTECH
 * Riontech on 17/1/18.
 */

public class ActivityStack {
    private static ActivityStack instance;
    private HashMap<String, ArrayList<Activity>> activityStacks;

    private ActivityStack() {
        activityStacks = new HashMap<>();
    }

    public static ActivityStack getInstance() {
        if (instance == null) {
            synchronized (ActivityStack.class) {
                if (instance == null) {
                    instance = new ActivityStack();
                }
            }
        }
        return instance;
    }

    public void addActivity(String key, Activity activity) {
        ArrayList<Activity> activities = new ArrayList<>();
        if (hasKeyList(key)) {
            activities = activityStacks.get(key);
        }

        activities.add(activity);
        activityStacks.put(key, activities);
    }

    public void removeFromStack(String key) {
        if (hasKeyList(key))
            activityStacks.remove(key);
    }

    private boolean hasKeyList(String key) {
        return activityStacks.containsKey(key);
    }

    public void clearStack(String key) {
        ArrayList<Activity> activities = new ArrayList<>();
        if (hasKeyList(key))
            activities = activityStacks.get(key);

        for (Activity activity : activities) {
            activity.finish();
        }
    }
}
