/*
 * Copyright (c) 2016 riontech-xten
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.xtensolution.support.ui.fragment;

import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;

import com.xtensolution.support.ui.activity.CoreActionBarActivity;
import com.xtensolution.support.ui.activity.CoreBaseActivity;
import com.xtensolution.support.ui.activity.CoreDrawerActivity;
import com.xtensolution.support.ui.activity.CoreFragmentActivity;
import com.xtensolution.support.ui.listener.MenuCheckedListener;
import com.xtensolution.support.utils.AppLog;


/**
 * Created by Vaghela Mithun R. on 05-Jun-17.
 * vaghela.mithun@gmail.com
 */
public abstract class CoreBaseFragment extends Fragment implements MenuCheckedListener {

    private static final String TAG = CoreBaseFragment.class.getSimpleName();
    protected CoreBaseActivity mActivity;
    protected View mContentView;
    protected boolean mHasArrow = false;
    protected boolean mHasHamburger = true;
    protected boolean allowCurrentScreenTitle = true;
    protected OnFragmentInteractionListener mListener;

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setHasOptionsMenu(true);
    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        mContentView = inflater.inflate(getViewResourceId(), null, false);

        mActivity = (CoreBaseActivity) getActivity();
        setHasOptionsMenu(true);
        return mContentView;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        onViewBind();
    }

    @Override
    public void onResume() {

        if (getActivity() instanceof CoreActionBarActivity && allowCurrentScreenTitle) {
            CoreActionBarActivity activity = (CoreActionBarActivity) getActivity();
            activity.setActionBarTitle(getScreenTitle());
        }

        changeDrawerIconState();
        super.onResume();
    }

    public void setScreenTitle(String title) {
        if (getActivity() instanceof CoreActionBarActivity && allowCurrentScreenTitle) {
            CoreActionBarActivity activity = (CoreActionBarActivity) getActivity();
            activity.setActionBarTitle(title);
        }
    }

    @Override
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
    }

    public <T extends View> T _findViewById(int resId) {
        return (T) mContentView.findViewById(resId);
    }

    abstract public String getScreenTitle();

    abstract protected int getViewResourceId();

    abstract protected void onViewBind();

    private void changeDrawerIconState() {
        AppLog.d(TAG, "changeDrawerIconState: ");
        if (getActivity() instanceof CoreDrawerActivity) {
            CoreDrawerActivity activity = (CoreDrawerActivity) getActivity();
            activity.changeDrawerIndicator(mHasArrow, mHasHamburger);
        }
    }

    public int getPageMenuId() {
        return 0;
    }

    public void replaceFragment(Fragment fragment) {
        mActivity.replaceFragment(fragment);
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        if (context instanceof OnFragmentInteractionListener) {
            mListener = (OnFragmentInteractionListener) context;
        }
    }

    /**
     * This generic type of interface can be implemented by activities that contain this
     * fragment to allow an interaction in by extended subclass fragment to be communicated
     * to the mActivity and potentially other fragments contained in that
     * mActivity.
     * <p>
     * See the Android Training lesson <a href=
     * "http://developer.android.com/training/basics/fragments/communicating.html"
     * >Communicating with Other Fragments</a> for more information.
     */
    public interface OnFragmentInteractionListener<T> {
        /**
         * Use this factory method to be communicated
         * to the mActivity and potentially other fragments contained in that
         * mActivity using the provided parameters.
         *
         * @param object generic T type object
         */
        void onFragmentInteraction(T object);
    }

    public boolean isHomePage() {
        return false;
    }


    public boolean isAllowCurrentScreenTitle() {
        return allowCurrentScreenTitle;
    }

    public void setAllowCurrentScreenTitle(boolean allowCurrentScreenTitle) {
        this.allowCurrentScreenTitle = allowCurrentScreenTitle;
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        resetTitle();
    }

    @Override
    public void onDetach() {
        super.onDetach();
        resetTitle();
    }

    private void resetTitle() {
        if (getActivity() instanceof CoreFragmentActivity) {
            CoreFragmentActivity fragmentActivity = (CoreFragmentActivity) getActivity();
            fragmentActivity.resetTitle();
        }
    }
}
