/*
 * Copyright (c) 2016 riontech-xten
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.xtensolution.support.ui.custom;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;

import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;

import com.xtensolution.support.R;
import com.xtensolution.support.exceptions.HeaderAdapterNotFoundException;
import com.xtensolution.support.ui.adapter.StickyHeaderRecyclerAdapter;
import com.xtensolution.support.utils.ResourceUtils;

/**
 * Created by niravvalera on 04/12/17.
 */

public class HeaderRecyclerView extends RecyclerView {
    private static final String TAG = HeaderRecyclerView.class.getSimpleName();
    private long mHeaderId;
    private ViewHolder mHeaderHolder;
    private ViewHolder mChildHolder;

    public HeaderRecyclerView(Context context) {
        super(context);
    }

    public HeaderRecyclerView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public HeaderRecyclerView(Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    public void setAdapter(Adapter adapter) {
        StickyHeaderRecyclerAdapter headerRecyclerAdapter = null;
        if (adapter instanceof StickyHeaderRecyclerAdapter) {
            Log.d(TAG, "setAdapter: StickyHeaderRecyclerAdapter");
            headerRecyclerAdapter = (StickyHeaderRecyclerAdapter) adapter;
            for (int i = 0; i < adapter.getItemCount(); i++) {
                Log.d(TAG, "setAdapter: mHeaderHolder");
                if (headerRecyclerAdapter.getHeaderId(i) == mHeaderId) {
                    if (mHeaderHolder == null)
                        mHeaderHolder = headerRecyclerAdapter.onCreateHeaderViewHolder(this, adapter.getItemViewType(i));
                    adapter.bindViewHolder(mHeaderHolder, i);
                    Log.d(TAG, "setAdapter: mHeaderHolder");
                } else {
                    if (mChildHolder == null)
                        mChildHolder = headerRecyclerAdapter.onCreateViewHolder(this, adapter.getItemViewType(i));
                    adapter.bindViewHolder(mChildHolder, i);
                    Log.d(TAG, "setAdapter: mChildHolder");
                }
                mHeaderId = headerRecyclerAdapter.getHeaderId(i);
            }
        } else {
            throw new HeaderAdapterNotFoundException(ResourceUtils.getString(R.string.no_header_adepter));
        }
        super.setAdapter(adapter);
//        this.setAdapter(adapter);
    }


}
