/*
 * Copyright (c) 2016 xten
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.xtensolution.support.ui.activity;

import android.animation.ObjectAnimator;
import android.view.MenuItem;
import android.view.View;
import android.widget.ImageButton;

import androidx.annotation.NonNull;
import androidx.appcompat.app.ActionBarDrawerToggle;
import androidx.core.view.GravityCompat;
import androidx.drawerlayout.widget.DrawerLayout;
import androidx.fragment.app.Fragment;

import com.google.android.material.navigation.NavigationView;
import com.xtensolution.support.R;
import com.xtensolution.support.ui.fragment.CoreBaseFragment;
import com.xtensolution.support.ui.listener.MenuCheckedListener;
import com.xtensolution.support.utils.AppLog;

/**
 * Created by MIT on 01-Nov-17.
 */

public abstract class CoreDrawerActivity extends CoreFragmentActivity
        implements NavigationView.OnNavigationItemSelectedListener {

    private static final String TAG = CoreDrawerActivity.class.getSimpleName();

    protected ActionBarDrawerToggle mToggle;
    private boolean hasArrow;
    protected NavigationView mNavigationView;
    protected DrawerLayout mDrawerLayout;

    @Override
    protected void onActionBarAttached() {
        initDrawer(getDrawerLayoutId());
        initNavigation(getNavigationViewId());
        onDrawerAttached();
    }

    private void initDrawer(int drawerId) {
        mDrawerLayout = _findViewById(drawerId);
        mToggle = new ActionBarDrawerToggle(
                this, mDrawerLayout, mToolbar, R.string.navigation_drawer_open, R.string.navigation_drawer_close);

        mDrawerLayout.addDrawerListener(mToggle);
        mToggle.syncState();
    }

    private void initNavigation(int navigationViewId) {
        mNavigationView = _findViewById(navigationViewId);
        mNavigationView.setNavigationItemSelectedListener(this);
    }

    private ImageButton getToolbarNavigationButton() {
        int size = mToolbar.getChildCount();
        for (int i = 0; i < size; i++) {
            View child = mToolbar.getChildAt(i);
            if (child instanceof ImageButton) {
                ImageButton btn = (ImageButton) child;
                if (btn.getDrawable() == mToolbar.getNavigationIcon()) {
                    return btn;
                }
            }
        }
        return null;
    }

    public void changeDrawerIndicator(boolean arrow, boolean hamburger) {
        try {
            if (hasArrow != arrow) {
                int start = hamburger ? 0 : 1;
                hasArrow = arrow;
                int drawerLockMode = hamburger ? DrawerLayout.LOCK_MODE_UNLOCKED : DrawerLayout.LOCK_MODE_LOCKED_CLOSED;
                mDrawerLayout.setDrawerLockMode(drawerLockMode);

                ObjectAnimator.ofFloat(mToggle.getDrawerArrowDrawable(), "progress", start).start();
                getToolbarNavigationButton().setTag(arrow);
                mToolbar.setNavigationOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View view) {
                        boolean isArrow = (boolean) view.getTag();
                        if (isArrow)
                            onBackPressed();
                        else
                            mDrawerLayout.openDrawer(GravityCompat.START, true);
                    }
                });
                mToggle.syncState();
                changeSelectedMenu();
            }
        } catch (Exception e) {
            AppLog.e(TAG, e.getMessage(), e);
        }
    }

    private boolean hasDrawerClose() {
        if (mDrawerLayout.isDrawerOpen(GravityCompat.START)) {
            AppLog.d(TAG, "onBackPressed: isDrawerOpen :: START");
            closeDrawer(GravityCompat.START);
            return true;
        } else if (mDrawerLayout.isDrawerOpen(GravityCompat.END)) {
            AppLog.d(TAG, "onBackPressed: isDrawerOpen :: END");
            closeDrawer(GravityCompat.END);
            return true;
        }

        return false;
    }

    protected void closeDrawer(int gravity) {
        mDrawerLayout.closeDrawer(gravity);
    }

    public void onBackPressed() {
        try {
            AppLog.d(TAG, "onBackPressed: ");
            if (!hasDrawerClose()) {
                AppLog.d(TAG, "onBackPressed: else");
                changeSelectedMenu();
                changeHomeFragmentHomeIconState();
                super.onBackPressed();

                // To reset the title of fragment which is declare inside the xml layout
//                if (getFragmentContainer() != 0) {
//                    Fragment currentFragment = getSupportFragmentManager().findFragmentById(getFragmentContainer());
//                    if (currentFragment != null && currentFragment instanceof CoreBaseFragment) {
//                        CoreBaseFragment coreBaseFragment = (CoreBaseFragment) currentFragment;
//                        setActionBarTitle(coreBaseFragment.getScreenTitle());
//                    }
//                }
            }
        } catch (Exception e) {
            AppLog.e(TAG, e.getMessage(), e);
        }
    }

    protected abstract int getDrawerLayoutId();

    protected abstract int getNavigationViewId();

    protected abstract void onDrawerAttached();

    /**
     * Change selected menu item base on current
     * fragment loaded
     */
    @Override
    protected void changeSelectedMenu() {
        try {
            if (mNavigationView != null) {
                int checkedMenuId = getPageMenuId();
                if (getFragmentContainer() != 0) {
                    Fragment currentFragment = getSupportFragmentManager().findFragmentById(getFragmentContainer());
                    try {
                        AppLog.d(TAG, "changeSelectedMenu");
                        if (currentFragment != null && currentFragment instanceof MenuCheckedListener) {
                            MenuCheckedListener listener = (MenuCheckedListener) currentFragment;
                            checkedMenuId = listener.getPageMenuId();

//                            if (currentFragment instanceof CoreBaseFragment) {
//                                String title = ((CoreBaseFragment) currentFragment).getScreenTitle();
//                                setActionBarTitle(title);
//                            }
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                AppLog.d(TAG, "changeSelectedMenu::" + checkedMenuId);
                mNavigationView.setCheckedItem(checkedMenuId);
            }
        } catch (Exception e) {
            AppLog.e(TAG, e.getMessage(), e);
        }
    }

    @Override
    protected void onResume() {
        changeSelectedMenu();
        super.onResume();
    }

    /**
     * To handle arrow to hamburger icon when
     * Home Fragment re-initiate on screen
     */
    private void changeHomeFragmentHomeIconState() {
        int backStackCount = getSupportFragmentManager().getBackStackEntryCount();
        AppLog.d(TAG, "changeHomeFragmentHomeIconState: backStackCount::" + backStackCount);
        if (backStackCount == 1)
            changeDrawerIndicator(false, true);
    }

    @Override
    public boolean onNavigationItemSelected(@NonNull MenuItem item) {
        hasDrawerClose();
        return true;
    }
}
