/*
 * Decompiled with CFR 0.152.
 */
package com.xtensolution.support.utils;

import android.graphics.drawable.Drawable;
import android.text.SpannableString;
import android.text.method.LinkMovementMethod;
import android.text.style.BackgroundColorSpan;
import android.text.style.ClickableSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.ImageSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.StyleSpan;
import android.text.style.UnderlineSpan;
import android.view.View;
import android.widget.TextView;

public class SpannableUtils {
    private String string;
    private String spannableStr;
    private String[] spannableArray;
    private boolean isClickable;
    private boolean hasUnderline;
    private boolean isColored;
    private boolean hasStrike;
    private boolean isHighlight;
    private boolean isBold;
    private int textColor;
    private int highlightColor;
    private ClickAction action;
    private TextView textView;
    private Drawable drawable;

    public SpannableUtils(TextView textView) {
        this.textView = textView;
    }

    public String getString() {
        return this.string;
    }

    public void setString(String string2) {
        this.string = string2;
    }

    public String[] getSpannableArray() {
        return this.spannableArray;
    }

    public void setSpannableArray(String[] spannableArray) {
        this.spannableArray = spannableArray;
    }

    public String getSpannableStr() {
        return this.spannableStr;
    }

    public void setSpannableStr(String spannableStr) {
        this.spannableStr = spannableStr;
    }

    public boolean isClickable() {
        return this.isClickable;
    }

    public void setIsClickable(boolean isClickable) {
        this.isClickable = isClickable;
    }

    public boolean isHasUnderline() {
        return this.hasUnderline;
    }

    public void setHasUnderline(boolean hasUnderline) {
        this.hasUnderline = hasUnderline;
    }

    public boolean isColored() {
        return this.isColored;
    }

    public void setIsColored(boolean isColored) {
        this.isColored = isColored;
    }

    public boolean isHasStrike() {
        return this.hasStrike;
    }

    public void setHasStrike(boolean hasStrike) {
        this.hasStrike = hasStrike;
    }

    public boolean isHighlight() {
        return this.isHighlight;
    }

    public void setIsHighlight(boolean isHighlight) {
        this.isHighlight = isHighlight;
    }

    public boolean isBold() {
        return this.isBold;
    }

    public void setIsBold(boolean isBold) {
        this.isBold = isBold;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
    }

    public int getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColor(int highlightColor) {
        this.highlightColor = highlightColor;
    }

    public ClickAction getAction() {
        return this.action;
    }

    public void setAction(ClickAction action) {
        this.action = action;
    }

    public Drawable getDrawable() {
        return this.drawable;
    }

    public void setDrawable(Drawable drawable2) {
        this.drawable = drawable2;
    }

    public void buildSpannable() {
        SpannableString styledString = new SpannableString((CharSequence)this.string);
        if (this.spannableStr != null) {
            this.setSpan(this.spannableStr, styledString);
        } else if (this.spannableArray != null) {
            for (int i = 0; i < this.spannableArray.length; ++i) {
                this.setSpan(this.spannableArray[i], styledString);
            }
        } else {
            this.setSpan(this.string, styledString);
        }
        this.textView.setMovementMethod(LinkMovementMethod.getInstance());
        this.textView.setText((CharSequence)styledString);
    }

    private void setSpan(String str, SpannableString styledString) {
        int start = this.string.indexOf(str);
        int end = start + str.length();
        int exclusive = 33;
        if (this.isBold) {
            styledString.setSpan((Object)new StyleSpan(1), start, end, exclusive);
        } else {
            styledString.setSpan((Object)new StyleSpan(0), start, end, exclusive);
        }
        if (this.isClickable) {
            styledString.setSpan((Object)new ClickableText(str), start, end, exclusive);
        }
        if (this.isColored) {
            styledString.setSpan((Object)new ForegroundColorSpan(this.getTextColor()), start, end, exclusive);
        }
        if (this.hasStrike) {
            styledString.setSpan((Object)new StrikethroughSpan(), start, end, exclusive);
        }
        if (this.hasUnderline) {
            styledString.setSpan((Object)new UnderlineSpan(), start, end, exclusive);
        }
        if (this.isHighlight) {
            styledString.setSpan((Object)new BackgroundColorSpan(this.getHighlightColor()), start, end, exclusive);
        }
        if (this.drawable != null) {
            this.drawable.setBounds(0, 0, this.drawable.getIntrinsicWidth(), this.drawable.getIntrinsicHeight());
            ImageSpan imageSpan = new ImageSpan(this.drawable);
            styledString.setSpan((Object)imageSpan, styledString.length() - 1, styledString.length(), 18);
            int startImg = styledString.getSpanStart((Object)imageSpan);
            int endImg = styledString.getSpanEnd((Object)imageSpan);
            ClickableSpan clickableSpan = new ClickableSpan(){

                public void onClick(View widget) {
                    SpannableUtils.this.action.onClickImage();
                }
            };
            styledString.setSpan((Object)clickableSpan, startImg, endImg, 18);
        }
    }

    private class ClickableText
    extends ClickableSpan {
        private String clicked;

        public ClickableText(String clicked) {
            this.clicked = clicked;
        }

        public void onClick(View view) {
            SpannableUtils.this.action.onClickAction(this.clicked);
        }
    }

    public static interface ClickAction {
        public void onClickAction(String var1);

        public void onClickImage();
    }
}

