/*
 * Decompiled with CFR 0.152.
 */
package com.xtensolution.support.utils;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import androidx.annotation.ArrayRes;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.StringRes;
import androidx.core.content.ContextCompat;
import com.xtensolution.support.CoreApp;

public class ResourceUtils {
    public static String getString(@StringRes int stringId) {
        return CoreApp.getInstance().getString(stringId);
    }

    public static String[] getStringArray(@ArrayRes int stringId) {
        return CoreApp.getInstance().getResources().getStringArray(stringId);
    }

    public static int[] getIntArray(@ArrayRes int intId) {
        return CoreApp.getInstance().getResources().getIntArray(intId);
    }

    public static Drawable getDrawable(@DrawableRes int drawableId) {
        return ContextCompat.getDrawable((Context)CoreApp.getInstance().getBaseContext(), (int)drawableId);
    }

    public static int getColor(@ColorRes int colorId) {
        return ContextCompat.getColor((Context)CoreApp.getInstance().getBaseContext(), (int)colorId);
    }

    public static int getDimen(@DimenRes int dimenId) {
        return (int)CoreApp.getInstance().getResources().getDimension(dimenId);
    }

    public static int dpToPx(int dp) {
        return (int)((float)dp * Resources.getSystem().getDisplayMetrics().density);
    }

    public static int pxToDp(int px) {
        return (int)((float)px / Resources.getSystem().getDisplayMetrics().density);
    }

    public static Drawable changeResourceColor(int color, int iconResId) {
        Drawable icon = ResourceUtils.getDrawable(iconResId);
        icon.setColorFilter(ResourceUtils.getColor(color), PorterDuff.Mode.SRC_ATOP);
        return icon;
    }

    public static Drawable changeResourceColor(int color, Drawable iconResId) {
        iconResId.setColorFilter(ResourceUtils.getColor(color), PorterDuff.Mode.SRC_ATOP);
        return iconResId;
    }
}

