/*
 * Decompiled with CFR 0.152.
 */
package com.xtensolution.support.utils;

import android.app.Activity;
import android.content.Context;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import com.xtensolution.support.utils.AppLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class PermissionUtils {
    public static final Integer LOCATION = 1;
    public static final Integer CALL = 2;
    public static final Integer WRITE_EXST = 3;
    public static final Integer READ_EXST = 4;
    public static final Integer CAMERA = 5;
    public static final Integer ACCOUNTS = 6;
    public static final Integer INTERNET = 7;
    private static final Integer CODE_WENT_WRONG = 0;
    public static final Integer READ_PHONE_STATE = 7;
    public static final Integer BOOT_COMPLETE = 8;

    public static Map<Integer, String> getPermissionMap() {
        HashMap<Integer, String> permissionCodes = new HashMap<Integer, String>();
        permissionCodes.put(LOCATION, "android.permission.ACCESS_FINE_LOCATION");
        permissionCodes.put(CALL, "android.permission.CALL_PHONE");
        permissionCodes.put(WRITE_EXST, "android.permission.WRITE_EXTERNAL_STORAGE");
        permissionCodes.put(READ_EXST, "android.permission.READ_EXTERNAL_STORAGE");
        permissionCodes.put(CAMERA, "android.permission.CAMERA");
        permissionCodes.put(ACCOUNTS, "android.permission.GET_ACCOUNTS");
        permissionCodes.put(INTERNET, "android.permission.INTERNET");
        permissionCodes.put(READ_PHONE_STATE, "android.permission.READ_PHONE_STATE");
        permissionCodes.put(BOOT_COMPLETE, "android.permission.RECEIVE_BOOT_COMPLETED");
        return permissionCodes;
    }

    public static String getPermission(int statusCode) {
        Map<Integer, String> codeMap = PermissionUtils.getPermissionMap();
        try {
            if (codeMap.containsKey(statusCode)) {
                return codeMap.get(statusCode);
            }
            return codeMap.get(CODE_WENT_WRONG);
        }
        catch (Exception e) {
            return codeMap.get(CODE_WENT_WRONG);
        }
    }

    public static String[] getPermissions(int[] statusCode) {
        Map<Integer, String> codeMap = PermissionUtils.getPermissionMap();
        String[] permissions = new String[statusCode.length];
        try {
            int i = 0;
            for (int code : statusCode) {
                permissions[i] = codeMap.containsKey(code) ? codeMap.get(code) : codeMap.get(CODE_WENT_WRONG);
                ++i;
            }
        }
        catch (Exception e) {
            permissions[0] = codeMap.get(CODE_WENT_WRONG);
        }
        return permissions;
    }

    public static void askForPermission(AppCompatActivity activity, int requestCode) {
        String permission2 = PermissionUtils.getPermission(requestCode);
        if (ContextCompat.checkSelfPermission((Context)activity, (String)permission2) != 0) {
            if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)permission2)) {
                ActivityCompat.requestPermissions((Activity)activity, (String[])new String[]{permission2}, (int)requestCode);
            } else {
                ActivityCompat.requestPermissions((Activity)activity, (String[])new String[]{permission2}, (int)requestCode);
            }
        } else {
            activity.onRequestPermissionsResult(requestCode, new String[]{permission2}, new int[]{0});
        }
    }

    public static void askForPermission(AppCompatActivity activity, int[] statusCode, int requestCode) {
        String[] permissions = PermissionUtils.getPermissions(statusCode);
        ArrayList<String> askToPermissions = new ArrayList<String>();
        ArrayList<String> granted = new ArrayList<String>();
        for (int i = 0; i < permissions.length; ++i) {
            String permission2 = permissions[i];
            if (ContextCompat.checkSelfPermission((Context)activity, (String)permission2) != 0) {
                askToPermissions.add(permission2);
                continue;
            }
            granted.add(permission2);
        }
        String[] grantedPermission = granted.toArray(new String[granted.size()]);
        String[] askPermission = askToPermissions.toArray(new String[askToPermissions.size()]);
        if (granted.size() > 0) {
            activity.onRequestPermissionsResult(requestCode, grantedPermission, new int[]{0});
        }
        if (askToPermissions.size() > 0) {
            ActivityCompat.requestPermissions((Activity)activity, (String[])askPermission, (int)requestCode);
        }
    }

    public static void askForPermission(AppCompatActivity activity, Fragment fragment, int[] statusCode, int requestCode) {
        String[] permissions = PermissionUtils.getPermissions(statusCode);
        ArrayList<String> askToPermissions = new ArrayList<String>();
        ArrayList<String> granted = new ArrayList<String>();
        for (int i = 0; i < permissions.length; ++i) {
            String permission2 = permissions[i];
            if (ContextCompat.checkSelfPermission((Context)activity, (String)permission2) != 0) {
                askToPermissions.add(permission2);
                continue;
            }
            granted.add(permission2);
        }
        String[] grantedPermission = (String[])granted.toArray();
        String[] askPermission = (String[])askToPermissions.toArray();
        if (granted.size() > 0) {
            fragment.onRequestPermissionsResult(requestCode, grantedPermission, new int[]{0});
        }
        if (askToPermissions.size() > 0) {
            fragment.requestPermissions(askPermission, requestCode);
        }
    }

    public static void askFragmentPermission(AppCompatActivity activity, Fragment fragment, int requestCode) {
        String permission2 = PermissionUtils.getPermission(requestCode);
        AppLog.e("TAG", "check permisssion....");
        if (ContextCompat.checkSelfPermission((Context)activity, (String)permission2) != 0) {
            if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)permission2)) {
                fragment.requestPermissions(new String[]{permission2}, requestCode);
            } else {
                fragment.requestPermissions(new String[]{permission2}, requestCode);
            }
        } else {
            fragment.onRequestPermissionsResult(requestCode, new String[]{permission2}, new int[]{0});
        }
    }
}

