/*
 * Decompiled with CFR 0.152.
 */
package com.xtensolution.support.utils;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.util.Base64;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.RoundedBitmapDrawable;
import androidx.core.graphics.drawable.RoundedBitmapDrawableFactory;
import com.xtensolution.support.exceptions.FileExtensionNotFoundException;
import com.xtensolution.support.utils.AppLog;
import com.xtensolution.support.utils.FileExtensionUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public class ImageUtils {
    private static final String TAG = ImageUtils.class.getSimpleName();

    private ImageUtils() {
    }

    public static byte[] getBytes(Bitmap bitmap) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 0, (OutputStream)stream);
        return stream.toByteArray();
    }

    public static Bitmap getImage(byte[] image) {
        return BitmapFactory.decodeByteArray((byte[])image, (int)0, (int)image.length);
    }

    public static Drawable getRoundedDrawable(Context context, int width, int height, Bitmap bmp) {
        Bitmap bitmap = Bitmap.createScaledBitmap((Bitmap)bmp, (int)width, (int)height, (boolean)false);
        RoundedBitmapDrawable drawable2 = RoundedBitmapDrawableFactory.create((Resources)context.getResources(), (Bitmap)bitmap);
        drawable2.setCircular(true);
        return drawable2;
    }

    public static Drawable getFileIcon(Context context, String extension) {
        int resId = FileExtensionUtils.getResourceId(extension);
        if (resId != 0) {
            return ContextCompat.getDrawable((Context)context, (int)resId);
        }
        throw new FileExtensionNotFoundException("File extension " + extension + " not found");
    }

    public static String convertToBase64(Bitmap bitmap) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)baos);
            byte[] b = baos.toByteArray();
            return Base64.encodeToString((byte[])b, (int)0);
        }
        catch (Exception e) {
            AppLog.e(TAG, e.getMessage(), e);
            return "";
        }
    }

    public static Bitmap convertBase64ToBitmap(String base64) {
        try {
            byte[] bytarray = Base64.decode((String)base64, (int)0);
            return BitmapFactory.decodeByteArray((byte[])bytarray, (int)0, (int)bytarray.length);
        }
        catch (Exception e) {
            AppLog.e(TAG, e.getMessage(), e);
            return null;
        }
    }
}

