/*
 * Decompiled with CFR 0.152.
 */
package com.xtensolution.support.ui.activity;

import android.animation.ObjectAnimator;
import android.app.Activity;
import android.view.MenuItem;
import android.view.View;
import android.widget.ImageButton;
import androidx.annotation.NonNull;
import androidx.appcompat.app.ActionBarDrawerToggle;
import androidx.drawerlayout.widget.DrawerLayout;
import androidx.fragment.app.Fragment;
import com.google.android.material.navigation.NavigationView;
import com.xtensolution.support.R;
import com.xtensolution.support.ui.activity.CoreFragmentActivity;
import com.xtensolution.support.ui.listener.MenuCheckedListener;
import com.xtensolution.support.utils.AppLog;

public abstract class CoreDrawerActivity
extends CoreFragmentActivity
implements NavigationView.OnNavigationItemSelectedListener {
    private static final String TAG = CoreDrawerActivity.class.getSimpleName();
    protected ActionBarDrawerToggle mToggle;
    private boolean hasArrow;
    protected NavigationView mNavigationView;
    protected DrawerLayout mDrawerLayout;

    @Override
    protected void onActionBarAttached() {
        this.initDrawer(this.getDrawerLayoutId());
        this.initNavigation(this.getNavigationViewId());
        this.onDrawerAttached();
    }

    private void initDrawer(int drawerId) {
        this.mDrawerLayout = (DrawerLayout)this._findViewById(drawerId);
        this.mToggle = new ActionBarDrawerToggle((Activity)this, this.mDrawerLayout, this.mToolbar, R.string.navigation_drawer_open, R.string.navigation_drawer_close);
        this.mDrawerLayout.addDrawerListener((DrawerLayout.DrawerListener)this.mToggle);
        this.mToggle.syncState();
    }

    private void initNavigation(int navigationViewId) {
        this.mNavigationView = (NavigationView)this._findViewById(navigationViewId);
        this.mNavigationView.setNavigationItemSelectedListener((NavigationView.OnNavigationItemSelectedListener)this);
    }

    private ImageButton getToolbarNavigationButton() {
        int size = this.mToolbar.getChildCount();
        for (int i = 0; i < size; ++i) {
            ImageButton btn;
            View child = this.mToolbar.getChildAt(i);
            if (!(child instanceof ImageButton) || (btn = (ImageButton)child).getDrawable() != this.mToolbar.getNavigationIcon()) continue;
            return btn;
        }
        return null;
    }

    public void changeDrawerIndicator(boolean arrow, boolean hamburger) {
        try {
            if (this.hasArrow != arrow) {
                boolean start = !hamburger;
                this.hasArrow = arrow;
                int drawerLockMode = hamburger ? 0 : 1;
                this.mDrawerLayout.setDrawerLockMode(drawerLockMode);
                ObjectAnimator.ofFloat((Object)this.mToggle.getDrawerArrowDrawable(), (String)"progress", (float[])new float[]{(float)start}).start();
                this.getToolbarNavigationButton().setTag((Object)arrow);
                this.mToolbar.setNavigationOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        boolean isArrow = (Boolean)view.getTag();
                        if (isArrow) {
                            CoreDrawerActivity.this.onBackPressed();
                        } else {
                            CoreDrawerActivity.this.mDrawerLayout.openDrawer(0x800003, true);
                        }
                    }
                });
                this.mToggle.syncState();
                this.changeSelectedMenu();
            }
        }
        catch (Exception e) {
            AppLog.e(TAG, e.getMessage(), e);
        }
    }

    private boolean hasDrawerClose() {
        if (this.mDrawerLayout.isDrawerOpen(0x800003)) {
            AppLog.d(TAG, "onBackPressed: isDrawerOpen :: START");
            this.closeDrawer(0x800003);
            return true;
        }
        if (this.mDrawerLayout.isDrawerOpen(0x800005)) {
            AppLog.d(TAG, "onBackPressed: isDrawerOpen :: END");
            this.closeDrawer(0x800005);
            return true;
        }
        return false;
    }

    protected void closeDrawer(int gravity) {
        this.mDrawerLayout.closeDrawer(gravity);
    }

    public void onBackPressed() {
        try {
            AppLog.d(TAG, "onBackPressed: ");
            if (!this.hasDrawerClose()) {
                AppLog.d(TAG, "onBackPressed: else");
                this.changeSelectedMenu();
                this.changeHomeFragmentHomeIconState();
                super.onBackPressed();
            }
        }
        catch (Exception e) {
            AppLog.e(TAG, e.getMessage(), e);
        }
    }

    protected abstract int getDrawerLayoutId();

    protected abstract int getNavigationViewId();

    protected abstract void onDrawerAttached();

    @Override
    protected void changeSelectedMenu() {
        block6: {
            try {
                if (this.mNavigationView == null) break block6;
                int checkedMenuId = this.getPageMenuId();
                if (this.getFragmentContainer() != 0) {
                    Fragment currentFragment = this.getSupportFragmentManager().findFragmentById(this.getFragmentContainer());
                    try {
                        AppLog.d(TAG, "changeSelectedMenu");
                        if (currentFragment != null && currentFragment instanceof MenuCheckedListener) {
                            MenuCheckedListener listener = (MenuCheckedListener)currentFragment;
                            checkedMenuId = listener.getPageMenuId();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                AppLog.d(TAG, "changeSelectedMenu::" + checkedMenuId);
                this.mNavigationView.setCheckedItem(checkedMenuId);
            }
            catch (Exception e) {
                AppLog.e(TAG, e.getMessage(), e);
            }
        }
    }

    @Override
    protected void onResume() {
        this.changeSelectedMenu();
        super.onResume();
    }

    private void changeHomeFragmentHomeIconState() {
        int backStackCount = this.getSupportFragmentManager().getBackStackEntryCount();
        AppLog.d(TAG, "changeHomeFragmentHomeIconState: backStackCount::" + backStackCount);
        if (backStackCount == 1) {
            this.changeDrawerIndicator(false, true);
        }
    }

    public boolean onNavigationItemSelected(@NonNull MenuItem item) {
        this.hasDrawerClose();
        return true;
    }
}

