/*
 * Copyright (c) 2016 riontech-xten
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.xtensolutions.support.utils;

import android.Manifest;
import android.content.pm.PackageManager;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by MIT on 11-Sep-17.
 */

public class PermissionUtils {

    public static final Integer LOCATION = 0x1;
    public static final Integer CALL = 0x2;
    public static final Integer WRITE_EXST = 0x3;
    public static final Integer READ_EXST = 0x4;
    public static final Integer CAMERA = 0x5;
    public static final Integer ACCOUNTS = 0x6;
    public static final Integer INTERNET = 0x7;
    private static final Integer CODE_WENT_WRONG = 0x0;
    public static final Integer READ_PHONE_STATE = 0x7;
    public static final Integer BOOT_COMPLETE = 0x8;

    public static Map<Integer, String> getPermissionMap() {
        Map<Integer, String> permissionCodes = new HashMap<>();

        permissionCodes.put(LOCATION, Manifest.permission.ACCESS_FINE_LOCATION);
        permissionCodes.put(CALL, Manifest.permission.CALL_PHONE);
        permissionCodes.put(WRITE_EXST, Manifest.permission.WRITE_EXTERNAL_STORAGE);
        permissionCodes.put(READ_EXST, Manifest.permission.READ_EXTERNAL_STORAGE);
        permissionCodes.put(CAMERA, Manifest.permission.CAMERA);
        permissionCodes.put(ACCOUNTS, Manifest.permission.GET_ACCOUNTS);
        permissionCodes.put(INTERNET, Manifest.permission.INTERNET);
        permissionCodes.put(READ_PHONE_STATE, Manifest.permission.READ_PHONE_STATE);
        permissionCodes.put(BOOT_COMPLETE, Manifest.permission.RECEIVE_BOOT_COMPLETED);
        return permissionCodes;
    }

    public static String getPermission(int statusCode) {
        Map<Integer, String> codeMap = getPermissionMap();
        try {
            if (codeMap.containsKey(statusCode))
                return codeMap.get(statusCode);
            else
                return codeMap.get(CODE_WENT_WRONG);
        } catch (Exception e) {
            return codeMap.get(CODE_WENT_WRONG);
        }
    }

    public static String[] getPermissions(int[] statusCode) {
        Map<Integer, String> codeMap = getPermissionMap();
        String[] permissions = new String[statusCode.length];
        try {
            int i = 0;
            for (int code : statusCode) {
                if (codeMap.containsKey(code))
                    permissions[i] = codeMap.get(code);
                else
                    permissions[i] = codeMap.get(CODE_WENT_WRONG);
                i++;
            }

        } catch (Exception e) {
            permissions[0] = codeMap.get(CODE_WENT_WRONG);
        }

        return permissions;
    }

    public static void askForPermission(AppCompatActivity activity, int requestCode) {
        String permission = getPermission(requestCode);
        if (ContextCompat.checkSelfPermission(activity, permission) != PackageManager.PERMISSION_GRANTED) {

            // Should we show an explanation?
            if (ActivityCompat.shouldShowRequestPermissionRationale(activity, permission)) {

                //This is called if user has denied the permission before
                //In this case I am just asking the permission again
                ActivityCompat.requestPermissions(activity,
                        new String[]{permission}, requestCode);

            } else {

                ActivityCompat.requestPermissions(activity,
                        new String[]{permission}, requestCode);
            }
        } else {
//            Toast.makeText(mActivity, "" + permission + " is already granted.", Toast.LENGTH_SHORT).show();
            activity.onRequestPermissionsResult(requestCode, new String[]{permission}, new int[]{PackageManager.PERMISSION_GRANTED});
        }
    }

    public static void askForPermission(AppCompatActivity activity, int[] statusCode, int requestCode) {
        String[] permissions = getPermissions(statusCode);
        List<String> askToPermissions = new ArrayList<>();
        List<String> granted = new ArrayList<>();
        for (int i = 0; i < permissions.length; i++) {
            String permission = permissions[i];
            if (ContextCompat.checkSelfPermission(activity, permission) != PackageManager.PERMISSION_GRANTED)
                askToPermissions.add(permission);
            else
                granted.add(permission);

        }

        String[] grantedPermission = granted.toArray(new String[granted.size()]);
        String[] askPermission = askToPermissions.toArray(new String[askToPermissions.size()]);

        if (granted.size() > 0)
            activity.onRequestPermissionsResult(requestCode, grantedPermission, new int[]{PackageManager.PERMISSION_GRANTED});

        if (askToPermissions.size() > 0)
            ActivityCompat.requestPermissions(activity, askPermission, requestCode);
    }

    public static void askForPermission(AppCompatActivity activity, Fragment fragment, int[] statusCode, int requestCode) {
        String[] permissions = getPermissions(statusCode);
        List<String> askToPermissions = new ArrayList<>();
        List<String> granted = new ArrayList<>();
        for (int i = 0; i < permissions.length; i++) {
            String permission = permissions[i];
            if (ContextCompat.checkSelfPermission(activity, permission) != PackageManager.PERMISSION_GRANTED)
                askToPermissions.add(permission);
            else
                granted.add(permission);

        }

        String[] grantedPermission = (String[]) granted.toArray();
        String[] askPermission = (String[]) askToPermissions.toArray();

        if (granted.size() > 0)
            fragment.onRequestPermissionsResult(requestCode, grantedPermission, new int[]{PackageManager.PERMISSION_GRANTED});

        if (askToPermissions.size() > 0)
            fragment.requestPermissions(askPermission, requestCode);
    }

    public static void askFragmentPermission(AppCompatActivity activity, Fragment fragment, int requestCode) {
        String permission = getPermission(requestCode);
        AppLog.e("TAG", "check permisssion....");
        if (ContextCompat.checkSelfPermission(activity, permission) != PackageManager.PERMISSION_GRANTED) {
            // Should we show an explanation?
            if (ActivityCompat.shouldShowRequestPermissionRationale(activity, permission)) {

                //This is called if user has denied the permission before
                //In this case I am just asking the permission again
                fragment.requestPermissions(new String[]{permission}, requestCode);

            } else {
                fragment.requestPermissions(new String[]{permission}, requestCode);
            }
        } else {
//            Toast.makeText(mActivity, "" + permission + " is already granted.", Toast.LENGTH_SHORT).show();
            fragment.onRequestPermissionsResult(requestCode, new String[]{permission}, new int[]{PackageManager.PERMISSION_GRANTED});
        }
    }
}
