/*
 * Copyright (c) 2016 riontech-xten
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.xtensolutions.support.utils;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.provider.Settings;
import android.support.v7.app.AppCompatActivity;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;

import com.xtensolutions.support.CoreApp;


public class DeviceUtils {
    private static final String TAG = DeviceUtils.class.getSimpleName();

    @SuppressLint("MissingPermission")
    public static String getDeviceUid() {
        String uniqueDeviceId = null;
        try {
            Context context = CoreApp.getInstance();
            TelephonyManager telephonyManager = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
            uniqueDeviceId = telephonyManager.getDeviceId();
            if (TextUtils.isEmpty(uniqueDeviceId)) {
                // for tablets
                ContentResolver cr = context.getContentResolver();
                uniqueDeviceId = Settings.Secure.getString(cr, Settings.Secure.ANDROID_ID);
            }
        } catch (Exception e) {
            AppLog.e(TAG, e.getMessage(), e);
        }

        return uniqueDeviceId;
    }

    public static int[] getDeviceSize(Context context) {
        DisplayMetrics metrics = getDisplayMetrics(context);
        return new int[]{metrics.widthPixels, metrics.heightPixels};
    }

    public static int getDeviceWidth(Context context) {
        return getDisplayMetrics(context).widthPixels;
    }

    public static int getDeviceHeight(Context context) {
        return getDisplayMetrics(context).heightPixels;
    }

    private static DisplayMetrics getDisplayMetrics(Context context) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        AppCompatActivity activity = (AppCompatActivity) context;
        activity.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics;
    }

}
