/*
 * Copyright (c) 2016 riontech-xten
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.xtensolutions.support.ui.fragment;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.xtensolutions.support.ui.activity.CoreBaseActivity;
import com.xtensolutions.support.ui.activity.CoreDrawerActivity;
import com.xtensolutions.support.ui.listener.MenuCheckedListener;
import com.xtensolutions.support.utils.AppLog;


/**
 * Created by Vaghela Mithun R. on 05-Jun-17.
 * vaghela.mithun@gmail.com
 */
public abstract class CoreBaseFragment extends Fragment implements MenuCheckedListener{

    private static final String TAG = CoreBaseFragment.class.getSimpleName();
    protected CoreBaseActivity mActivity;
    protected View mContentView;
    protected boolean mHasArrow = false;
    protected boolean mHasHamburger = true;
    private OnFragmentInteractionListener mListener;

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setHasOptionsMenu(true);
    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        mContentView = inflater.inflate(getViewResourceId(), null, false);
        mActivity = (CoreBaseActivity) getActivity();
        setHasOptionsMenu(true);
        onViewBind();
        return mContentView;
    }

    @Override
    public void onResume() {
        mActivity.setActionBarTitle(getScreenTitle());
        changeDrawerIconState();
        super.onResume();
    }

    public void setScreenTitle(String title){
        mActivity.setActionBarTitle(title);
    }

    @Override
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
    }

    public <T extends View> T _findViewById(int resId){
        return (T) mContentView.findViewById(resId);
    }
    abstract protected String getScreenTitle();

    abstract protected int getViewResourceId();

    abstract protected void onViewBind();

    private void changeDrawerIconState(){
        AppLog.d(TAG, "changeDrawerIconState: ");
        if(getActivity() instanceof CoreDrawerActivity){
            CoreDrawerActivity activity = (CoreDrawerActivity) getActivity();
            activity.changeDrawerIndicator(mHasArrow, mHasHamburger);
        }
    }

    public int getPageMenuId(){
        return 0;
    }

    public void replaceFragment(Fragment fragment){
        mActivity.replaceFragment(fragment);
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        if (context instanceof OnFragmentInteractionListener) {
            mListener = (OnFragmentInteractionListener) context;
        }
    }

    /**
     * This generic type of interface can be implemented by activities that contain this
     * fragment to allow an interaction in by extended subclass fragment to be communicated
     * to the mActivity and potentially other fragments contained in that
     * mActivity.
     * <p>
     * See the Android Training lesson <a href=
     * "http://developer.android.com/training/basics/fragments/communicating.html"
     * >Communicating with Other Fragments</a> for more information.
     */
    public interface OnFragmentInteractionListener<T> {
        /**
         * Use this factory method to be communicated
         * to the mActivity and potentially other fragments contained in that
         * mActivity using the provided parameters.
         * @param object generic T type object
         */
        void onFragmentInteraction(T object);
    }

    public boolean isHomePage(){
        return false;
    }


}
