/*
 * Copyright (c) 2016 riontech-xten
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.xtensolutions.support.ui.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;

import com.xtensolutions.support.utils.AppLog;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by MIT on 10/21/2016.
 */
public abstract class BaseRecyclerViewAdapter<T> extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private static final String TAG = BaseRecyclerViewAdapter.class.getSimpleName();
    protected LayoutInflater inflater;
    public static final int PAGE_LIMIT = 15;
    protected Context context;
    protected List<T> objectsList;
    protected static final int FOOTER_VIEW = 2;
    protected int displayItemCount;
    private PaginationListener paginationListener;
    private boolean isPageLoading;

    public BaseRecyclerViewAdapter(Context context) {
        this(context, new ArrayList<T>());
    }

    public BaseRecyclerViewAdapter(Context context, List<T> objectsList) {
        this.context = context;
        this.objectsList = objectsList;
        this.inflater = LayoutInflater.from(context);
        displayItemCount = objectsList.size();

        try {

//            Field stringListField = Test.class.getDeclaredField("stringList");
//            ParameterizedType stringListType = (ParameterizedType) stringListField.getGenericType();
//            Class<?> stringListClass = (Class<?>) stringListType.getActualTypeArguments()[0];
//            System.out.println(stringListClass); // class java.lang.String.


//            Type superclassType = this.getClass().getGenericSuperclass();
//            Class<?> clazz = (Class<?>) ((ParameterizedType) superclassType).getActualTypeArguments()[0];
//            AppLog.d(TAG, "Adapter name ::" + clazz);
//
//            Field field = BaseRecyclerViewAdapter.class.getDeclaredField("objectsList");
//            field.setAccessible(true);
//            Type type = field.getGenericType();
//
//            AppLog.d(TAG, "List class ::" + objectsList.getClass());
//            Type listtype = objectsList.getClass().getGenericSuperclass();
//
//            if (type instanceof ParameterizedType) {
//                ParameterizedType pt = (ParameterizedType) type;
//                Class<?> listClass = (Class<?>) pt.getActualTypeArguments()[0];
//                System.out.println("Class type: " + listClass);
//                System.out.println("raw type: " + pt.getRawType());
//                System.out.println("owner type: " + pt.getOwnerType());
//                System.out.println("actual type args:");
//                for (Type t : pt.getActualTypeArguments()) {
//                    System.out.println("    " + t);
//                }
//            }

//            ParameterizedType type  = (ParameterizedType) listtype;
//            AppLog.d(TAG, "Model name ::" + type);
//            AppLog.d(TAG, "Model name ::" + type.getActualTypeArguments()[0]);

//            Class<?> listclazz = (Class<?>) ((ParameterizedType) listtype).getActualTypeArguments()[0];
//            AppLog.d(TAG, "Model name ::" + listclazz.getSimpleName());
//            AppLog.d(TAG, "Adapter name ::" + ((ParameterizedType) superclassType).getRawType().getClass().getName());
//            AppLog.d(TAG, "Model name ::" + objectsList.getClass().getComponentType().getSimpleName());

        } catch (Exception e) {
            AppLog.e(TAG, e.getMessage(), e);
        }
    }

    public void setPageLoading(boolean pageLoading) {
        isPageLoading = pageLoading;
    }

    public boolean isPageLoading() {
        return isPageLoading;
    }

    public void setDisplayItemCount(int itemCount) {
        this.displayItemCount = itemCount;
    }

    public void setPaginationListener(PaginationListener paginationListener) {
        this.paginationListener = paginationListener;
    }

    @Override
    public int getItemViewType(int position) {
        return super.getItemViewType(position);
    }

    @Override
    public int getItemCount() {
        if (objectsList.size() < displayItemCount)
            displayItemCount = objectsList.size();
        return displayItemCount;
    }

    public int getCount() {
        return objectsList.size();
    }

    public T getItem(int position) {
        return objectsList.get(position);
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    public void updateList(List<T> newData) {
//        objectsList.clear();
        objectsList = newData;
        displayItemCount = objectsList.size();
        notifyDataSetChanged();
    }

    public void add(T item) {
        objectsList.add(item);
        displayItemCount = objectsList.size();
        notifyDataSetChanged();
    }

    public void addAt(int position, T item) {
        objectsList.add(position, item);
        displayItemCount = objectsList.size();
        notifyDataSetChanged();
    }

    public void addList(List<T> items) {
        objectsList.addAll(0, items);
        displayItemCount = objectsList.size();
        notifyDataSetChanged();
    }

    public void addAtLast(List<T> items) {
        if (isPageLoading())
            objectsList.addAll(objectsList.size() - 1, items);
        else
            objectsList.addAll(items);
        displayItemCount = objectsList.size();
        notifyDataSetChanged();
    }


    public List<T> getList() {
        return objectsList;
    }

    public void remove(T item) {
        objectsList.remove(item);
        displayItemCount = objectsList.size();
        notifyDataSetChanged();
    }

    public void remove(int position) {
        objectsList.remove(position);
        displayItemCount = objectsList.size();
        notifyItemRemoved(position);
    }

    public interface PaginationListener {
        void onPageLoad(int offset);
    }

    protected void loadNextPage(int position) {
        if (paginationListener != null && position == (objectsList.size() - 1)) {
            if (isPageLoading())
                paginationListener.onPageLoad(objectsList.size() - 1);
            else
                paginationListener.onPageLoad(objectsList.size());
        }
    }
}
