/*
 * Copyright (c) 2016 xten
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.xtensolutions.support.ui.activity;

import android.animation.ObjectAnimator;
import android.support.annotation.NonNull;
import android.support.design.widget.NavigationView;
import android.support.v4.app.Fragment;
import android.support.v4.view.GravityCompat;
import android.support.v4.widget.DrawerLayout;
import android.support.v7.app.ActionBarDrawerToggle;
import android.view.MenuItem;
import android.view.View;

import com.xtensolutions.support.R;
import com.xtensolutions.support.ui.listener.MenuCheckedListener;
import com.xtensolutions.support.utils.AppLog;

/**
 * Created by MIT on 01-Nov-17.
 */

public abstract class CoreDrawerActivity extends CoreActionBarActivity
        implements NavigationView.OnNavigationItemSelectedListener, MenuCheckedListener {

    private static final String TAG = CoreDrawerActivity.class.getSimpleName();

    protected ActionBarDrawerToggle mToggle;
    private boolean hasArrow;
    protected NavigationView mNavigationView;
    protected DrawerLayout mDrawerLayout;

    @Override
    protected void onActionBarAttached() {
        initDrawer(getDrawerLayoutId());
        initNavigation(getNavigationViewId());
        onDrawerAttached();
    }

    private void initDrawer(int drawerId) {
        mDrawerLayout = _findViewById(drawerId);
        mToggle = new ActionBarDrawerToggle(
                this, mDrawerLayout, mToolbar, R.string.navigation_drawer_open, R.string.navigation_drawer_close);

        mDrawerLayout.addDrawerListener(mToggle);
        mToggle.syncState();
    }

    private void initNavigation(int navigationViewId) {
        mNavigationView = _findViewById(navigationViewId);
        mNavigationView.setNavigationItemSelectedListener(this);
    }

    public void changeDrawerIndicator(boolean arrow, boolean hamburger) {
        try {
            if (hasArrow != arrow) {
                int start = hamburger ? 0 : 1;
                hasArrow = arrow;
                int drawerLockMode = hamburger ? DrawerLayout.LOCK_MODE_UNLOCKED : DrawerLayout.LOCK_MODE_LOCKED_CLOSED;
                mDrawerLayout.setDrawerLockMode(drawerLockMode);

                ObjectAnimator.ofFloat(mToggle.getDrawerArrowDrawable(), "progress", start).start();
                mToolbar.setNavigationOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View view) {
                        if (hasArrow)
                            onBackPressed();
                        else
                            mDrawerLayout.openDrawer(GravityCompat.START, true);
                    }
                });
                mToggle.syncState();
                changeSelectedMenu();
            }
        } catch (Exception e) {
            AppLog.e(TAG, e.getMessage(), e);
        }
    }

    protected void closeDrawer(int gravity) {
        mDrawerLayout.closeDrawer(gravity);
    }

    public void onBackPressed() {
        try {
            AppLog.d(TAG, "onBackPressed: ");
            if (mDrawerLayout.isDrawerOpen(GravityCompat.START)) {
                AppLog.d(TAG, "onBackPressed: isDrawerOpen :: START");
                closeDrawer(GravityCompat.START);
            } else if (mDrawerLayout.isDrawerOpen(GravityCompat.END)) {
                AppLog.d(TAG, "onBackPressed: isDrawerOpen :: END");
                closeDrawer(GravityCompat.END);
            } else {
                AppLog.d(TAG, "onBackPressed: else");
                changeSelectedMenu();
                changeHomeFragmentHomeIconState();
                super.onBackPressed();
            }
        } catch (Exception e) {
            AppLog.e(TAG, e.getMessage(), e);
        }
    }

    protected abstract int getDrawerLayoutId();

    protected abstract int getNavigationViewId();

    protected abstract void onDrawerAttached();

    /**
     * Change selected menu item base on current
     * fragment loaded
     */
    @Override
    protected void changeSelectedMenu() {
        try {
            if (mNavigationView != null) {
                int checkedMenuId = getPageMenuId();
                if (getFragmentContainer() != 0) {
                    Fragment currentFragment = getSupportFragmentManager().findFragmentById(getFragmentContainer());
                    try {
                        AppLog.d(TAG, "changeSelectedMenu");
                        if (currentFragment != null && currentFragment instanceof MenuCheckedListener) {
                            MenuCheckedListener listener = (MenuCheckedListener) currentFragment;
                            checkedMenuId = listener.getPageMenuId();
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                AppLog.d(TAG, "changeSelectedMenu::" + checkedMenuId);
                mNavigationView.setCheckedItem(checkedMenuId);
            }
        } catch (Exception e) {
            AppLog.e(TAG, e.getMessage(), e);
        }
    }

    @Override
    protected void onResume() {
        changeSelectedMenu();
        super.onResume();
    }

    /**
     * To handle arrow to hamburger icon when
     * Home Fragment re-initiate on screen
     */
    private void changeHomeFragmentHomeIconState() {
        int backStackCount = getSupportFragmentManager().getBackStackEntryCount();
        AppLog.d(TAG, "changeHomeFragmentHomeIconState: backStackCount::" + backStackCount);
        if (backStackCount == 1)
            changeDrawerIndicator(false, true);
    }

    @Override
    public boolean isHomePage() {
        return false;
    }

    @Override
    public int getPageMenuId() {
        return 0;
    }

    @Override
    public boolean onNavigationItemSelected(@NonNull MenuItem item) {
        return true;
    }
}
