/*
 * Copyright (c) 2016 riontech-xten
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.xtensolutions.support.ui.activity;

import android.support.v7.widget.Toolbar;

/**
 * A abstract {@link CoreBaseActivity} subclass.
 * Activities that contain actionbar must extends this class
 */

public abstract class CoreActionBarActivity extends CoreBaseActivity {
    protected Toolbar mToolbar;

    @Override
    protected void onContentViewBind() {
        mToolbar = _findViewById(getToolbarId());
        setSupportActionBar(mToolbar);
        mActionBar = getSupportActionBar();
        onActionBarAttached();
    }

    /**
     * Use this factory method to get the toolbar resource id
     * to init the toolbar from extend child class.
     * @return toolbar resource id.
     */
    protected abstract int getToolbarId();

    /**
     * Use this factory method to listen the actionbar has been
     * attached to activity
     */
    protected abstract void onActionBarAttached();

    @Override
    protected void onResume() {
        super.onResume();
    }
}
