/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions.marklogic;

import com.marklogic.xcc.Content;
import com.marklogic.xcc.ContentCreateOptions;
import com.marklogic.xcc.ContentFactory;
import com.marklogic.xcc.ContentSource;
import com.marklogic.xcc.Session;
import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.extensions.marklogic.XCCStep;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.Base64;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.TreeWriter;
import com.xmlcalabash.util.XProcURIResolver;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Locale;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

@XMLCalabash(name="ml:insert-document", type="{http://xmlcalabash.com/ns/extensions/marklogic}insert-document")
public class XCCInsertDocument
extends XCCStep {
    private static final QName _encoding = new QName("encoding");
    private static final QName _bufferSize = new QName("", "buffer-size");
    private static final QName _collections = new QName("", "collections");
    private static final QName _format = new QName("", "format");
    private static final QName _language = new QName("", "language");
    private static final QName _locale = new QName("", "locale");
    private static final QName _uri = new QName("", "uri");

    public XCCInsertDocument(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        String format = "xml";
        if (this.getOption(_format) != null) {
            format = this.getOption(_format).getString();
        }
        if (!("xml".equals(format) || "text".equals(format) || "binary".equals(format))) {
            throw new UnsupportedOperationException("Format must be 'xml', 'text', or 'binary'.");
        }
        XdmNode doc = this.source.read();
        XdmNode root = S9apiUtils.getDocumentElement((XdmNode)doc);
        String docstring = null;
        byte[] docbinary = null;
        if ("xml".equals(format)) {
            Serializer serializer = this.makeSerializer();
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            serializer.setOutputStream((OutputStream)stream);
            S9apiUtils.serialize((XProcRuntime)this.runtime, (XdmNode)doc, (Serializer)serializer);
            try {
                docstring = stream.toString("UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                throw new XProcException((Throwable)uee);
            }
        } else if ("text".equals(format)) {
            docstring = doc.getStringValue();
        } else if ("base64".equals(root.getAttributeValue(_encoding))) {
            docbinary = Base64.decode((String)doc.getStringValue());
        } else if (root.getAttributeValue(_encoding) == null) {
            docstring = root.getStringValue();
        } else {
            throw new UnsupportedOperationException("Binary content must be base64 encoded.");
        }
        ContentCreateOptions options = ContentCreateOptions.newXmlInstance();
        if ("xml".equals(format)) {
            options.setFormatXml();
            options.setEncoding("UTF-8");
        }
        if ("text".equals(format)) {
            options.setFormatText();
            options.setEncoding("UTF-8");
        }
        if ("binary".equals(format)) {
            options.setFormatBinary();
        }
        if (this.getOption(_bufferSize) != null) {
            options.setBufferSize(this.getOption(_bufferSize).getInt());
        }
        if (this.getOption(_collections) != null) {
            String[] collections = this.getOption(_collections).getString().split("\\s+");
            options.setCollections(collections);
        }
        if (this.getOption(_language) != null) {
            options.setLanguage(this.getOption(_language).getString());
        }
        if (this.getOption(_locale) != null) {
            String value = this.getOption(_locale).getString();
            Locale locale = new Locale(value);
            options.setLocale(locale);
        }
        String dburi = this.getOption(_uri).getString();
        Content content = null;
        content = docbinary == null ? ContentFactory.newContent((String)dburi, (String)docstring, (ContentCreateOptions)options) : ContentFactory.newContent((String)dburi, (byte[])docbinary, (ContentCreateOptions)options);
        ContentSource contentSource = this.constructContentSource();
        try {
            Session session = contentSource.newSession();
            session.insertContent(content);
            session.close();
        }
        catch (Exception e) {
            throw new XProcException((Throwable)e);
        }
        TreeWriter tree = new TreeWriter(this.runtime);
        tree.startDocument(this.step.getNode().getBaseURI());
        tree.addStartElement(XProcConstants.c_result);
        tree.startContent();
        tree.addText(dburi);
        tree.addEndElement();
        tree.endDocument();
        this.result.write(tree.getResult());
    }

    public static void configureStep(XProcRuntime runtime) {
        XProcURIResolver resolver = runtime.getResolver();
        URIResolver uriResolver = resolver.getUnderlyingURIResolver();
        StepResolver myResolver = new StepResolver(uriResolver);
        resolver.setUnderlyingURIResolver((URIResolver)myResolver);
    }

    private static class StepResolver
    implements URIResolver {
        Logger logger = LoggerFactory.getLogger(XCCInsertDocument.class);
        URIResolver nextResolver = null;

        public StepResolver(URIResolver next) {
            this.nextResolver = next;
        }

        @Override
        public Source resolve(String href, String base) throws TransformerException {
            try {
                URI baseURI = new URI(base);
                URI xpl = baseURI.resolve(href);
                if ("http://xmlcalabash.com/extension/steps/marklogic-xcc.xpl".equals(xpl.toASCIIString())) {
                    URL url = XCCInsertDocument.class.getResource("/com/xmlcalabash/extensions/xcc/library.xpl");
                    this.logger.debug("Reading library.xpl for ml:insert-document from " + url);
                    InputStream s = XCCInsertDocument.class.getResourceAsStream("/com/xmlcalabash/extensions/xcc/library.xpl");
                    if (s != null) {
                        SAXSource source = new SAXSource(new InputSource(s));
                        return source;
                    }
                    this.logger.info("Failed to read /com/xmlcalabash/extensions/xcc/library.xpl for ml:insert-document");
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            if (this.nextResolver != null) {
                return this.nextResolver.resolve(href, base);
            }
            return null;
        }
    }
}

