/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions.marklogic;

import com.marklogic.xcc.AdhocQuery;
import com.marklogic.xcc.ContentSource;
import com.marklogic.xcc.Request;
import com.marklogic.xcc.ResultSequence;
import com.marklogic.xcc.Session;
import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.extensions.marklogic.XCCStep;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.XProcURIResolver;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

@XMLCalabash(name="ml:adhoc-query", type="{http://xmlcalabash.com/ns/extensions/marklogic}adhoc-query")
public class XCCAdhocQuery
extends XCCStep {
    public XCCAdhocQuery(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        XdmNode queryDocument = this.source.read();
        String queryString = queryDocument.getStringValue();
        ContentSource contentSource = this.constructContentSource();
        try {
            Session session = contentSource.newSession();
            AdhocQuery request = session.newAdhocQuery(queryString);
            this.processParams((Request)request);
            ResultSequence rs = session.submitRequest((Request)request);
            this.serializeResultSequence(rs);
            session.close();
        }
        catch (Exception e) {
            throw new XProcException((Throwable)e);
        }
    }

    public static void configureStep(XProcRuntime runtime) {
        XProcURIResolver resolver = runtime.getResolver();
        URIResolver uriResolver = resolver.getUnderlyingURIResolver();
        StepResolver myResolver = new StepResolver(uriResolver);
        resolver.setUnderlyingURIResolver((URIResolver)myResolver);
    }

    private static class StepResolver
    implements URIResolver {
        Logger logger = LoggerFactory.getLogger(XCCAdhocQuery.class);
        URIResolver nextResolver = null;

        public StepResolver(URIResolver next) {
            this.nextResolver = next;
        }

        @Override
        public Source resolve(String href, String base) throws TransformerException {
            try {
                URI baseURI = new URI(base);
                URI xpl = baseURI.resolve(href);
                if ("http://xmlcalabash.com/extension/steps/marklogic-xcc.xpl".equals(xpl.toASCIIString())) {
                    URL url = XCCAdhocQuery.class.getResource("/com/xmlcalabash/extensions/xcc/library.xpl");
                    this.logger.debug("Reading library.xpl for ml:adhoc-query from " + url);
                    InputStream s = XCCAdhocQuery.class.getResourceAsStream("/com/xmlcalabash/extensions/xcc/library.xpl");
                    if (s != null) {
                        SAXSource source = new SAXSource(new InputSource(s));
                        return source;
                    }
                    this.logger.info("Failed to read /com/xmlcalabash/extensions/xcc/library.xpl for ml:adhoc-query");
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            if (this.nextResolver != null) {
                return this.nextResolver.resolve(href, base);
            }
            return null;
        }
    }
}

