/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions.marklogic;

import com.marklogic.xcc.ContentSource;
import com.marklogic.xcc.ContentSourceFactory;
import com.marklogic.xcc.Request;
import com.marklogic.xcc.ResultItem;
import com.marklogic.xcc.ResultSequence;
import com.marklogic.xcc.ValueFactory;
import com.marklogic.xcc.types.XName;
import com.marklogic.xcc.types.XSString;
import com.marklogic.xcc.types.XdmBinary;
import com.marklogic.xcc.types.XdmDocument;
import com.marklogic.xcc.types.XdmElement;
import com.marklogic.xcc.types.XdmItem;
import com.marklogic.xcc.types.XdmValue;
import com.marklogic.xcc.types.XdmVariable;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.Base64;
import com.xmlcalabash.util.TreeWriter;
import java.io.StringReader;
import java.net.URI;
import java.util.Hashtable;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import org.xml.sax.InputSource;

public abstract class XCCStep
extends DefaultStep {
    private static final QName _user = new QName("", "user");
    private static final QName _password = new QName("", "password");
    private static final QName _host = new QName("", "host");
    private static final QName _port = new QName("", "port");
    private static final QName _contentBase = new QName("", "content-base");
    private static final QName _wrapper = new QName("", "wrapper");
    private static final QName _encoding = new QName("encoding");
    private static final QName _auth_method = new QName("auth-method");
    private static final QName c_encoding = new QName("c", "http://www.w3.org/ns/xproc-step", "encoding");
    protected static final String library_xpl = "http://xmlcalabash.com/extension/steps/marklogic-xcc.xpl";
    protected static final String library_url = "/com/xmlcalabash/extensions/xcc/library.xpl";
    protected ReadablePipe source = null;
    protected WritablePipe result = null;
    protected Hashtable<QName, String> params = new Hashtable();
    protected String host = null;
    protected int port = 0;
    protected String user = null;
    protected String password = null;
    protected String contentBase = null;
    protected QName wrapper = XProcConstants.c_result;

    public XCCStep(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    public void setInput(String port, ReadablePipe pipe) {
        this.source = pipe;
    }

    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    public void setParameter(QName name, RuntimeValue value) {
        this.params.put(name, value.getString());
    }

    public void reset() {
        if (this.source != null) {
            this.source.resetReader();
        }
        if (this.result != null) {
            this.result.resetWriter();
        }
    }

    public void run() throws SaxonApiException {
        super.run();
        this.host = this.getOption(_host, "");
        this.port = this.getOption(_port, 0);
        this.user = this.getOption(_user, "");
        this.password = this.getOption(_password, "");
        this.contentBase = this.getOption(_contentBase, "");
        if (this.getOption(_wrapper) != null) {
            this.wrapper = this.getOption(_wrapper).getQName();
        }
    }

    protected ContentSource constructContentSource() {
        ContentSource contentSource = null;
        try {
            URI uri = URI.create("xcc://" + this.user + ":" + this.password + "@" + this.host + ":" + this.port + "/" + this.contentBase);
            contentSource = ContentSourceFactory.newContentSource((URI)uri);
        }
        catch (Exception e) {
            throw new XProcException((Throwable)e);
        }
        if ("basic".equals(this.getOption(_auth_method, ""))) {
            contentSource.setAuthenticationPreemptive(true);
        }
        return contentSource;
    }

    protected void processParams(Request request) {
        for (QName name : this.params.keySet()) {
            XSString value = ValueFactory.newXSString((String)this.params.get(name));
            XName xname = new XName(name.getNamespaceURI(), name.getLocalName());
            XdmVariable myVariable = ValueFactory.newVariable((XName)xname, (XdmValue)value);
            request.setVariable(myVariable);
        }
    }

    protected void serializeResultSequence(ResultSequence rs) {
        while (rs.hasNext()) {
            XdmNode node;
            TreeWriter treeWriter;
            ResultItem rsItem = rs.next();
            XdmItem item = rsItem.getItem();
            if (item instanceof XdmDocument || item instanceof XdmElement) {
                StringReader sr = new StringReader(item.asString());
                XdmNode xccXML = this.runtime.parse(new InputSource(sr));
                this.result.write(xccXML);
                continue;
            }
            if (item instanceof XdmBinary) {
                String base64 = Base64.encodeBytes((byte[])((XdmBinary)item).asBinaryData());
                treeWriter = new TreeWriter(this.runtime);
                treeWriter.startDocument(this.step.getNode().getBaseURI());
                treeWriter.addStartElement(this.wrapper);
                if ("http://www.w3.org/ns/xproc-step".equals(this.wrapper.getNamespaceURI())) {
                    treeWriter.addAttribute(_encoding, "base64");
                } else {
                    treeWriter.addAttribute(c_encoding, "base64");
                }
                treeWriter.startContent();
                treeWriter.addText(base64);
                treeWriter.addEndElement();
                treeWriter.endDocument();
                node = treeWriter.getResult();
                this.result.write(node);
                continue;
            }
            String text = item.asString();
            treeWriter = new TreeWriter(this.runtime);
            treeWriter.startDocument(this.step.getNode().getBaseURI());
            treeWriter.addStartElement(this.wrapper);
            treeWriter.startContent();
            treeWriter.addText(text);
            treeWriter.addEndElement();
            treeWriter.endDocument();
            node = treeWriter.getResult();
            this.result.write(node);
        }
    }
}

