/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions.marklogic;

import com.marklogic.xcc.AdhocQuery;
import com.marklogic.xcc.ContentSource;
import com.marklogic.xcc.ContentSourceFactory;
import com.marklogic.xcc.Request;
import com.marklogic.xcc.ResultItem;
import com.marklogic.xcc.ResultSequence;
import com.marklogic.xcc.Session;
import com.marklogic.xcc.ValueFactory;
import com.marklogic.xcc.types.XName;
import com.marklogic.xcc.types.XSString;
import com.marklogic.xcc.types.XdmBinary;
import com.marklogic.xcc.types.XdmDocument;
import com.marklogic.xcc.types.XdmElement;
import com.marklogic.xcc.types.XdmItem;
import com.marklogic.xcc.types.XdmValue;
import com.marklogic.xcc.types.XdmVariable;
import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.Base64;
import com.xmlcalabash.util.TreeWriter;
import java.io.StringReader;
import java.util.Hashtable;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import org.xml.sax.InputSource;

@XMLCalabash(name="ml:adhoc-query", type="{http://xmlcalabash.com/ns/extensions/marklogic}adhoc-query")
public class XCCAdhocQuery
extends DefaultStep {
    private static final QName _user = new QName("", "user");
    private static final QName _password = new QName("", "password");
    private static final QName _host = new QName("", "host");
    private static final QName _port = new QName("", "port");
    private static final QName _contentBase = new QName("", "content-base");
    private static final QName _wrapper = new QName("", "wrapper");
    private static final QName _encoding = new QName("encoding");
    private static final QName _auth_method = new QName("auth-method");
    private static final QName c_encoding = new QName("c", "http://www.w3.org/ns/xproc-step", "encoding");
    private ReadablePipe source = null;
    private WritablePipe result = null;
    private Hashtable<QName, String> params = new Hashtable();

    public XCCAdhocQuery(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    public void setInput(String port, ReadablePipe pipe) {
        this.source = pipe;
    }

    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    public void setParameter(QName name, RuntimeValue value) {
        this.params.put(name, value.getString());
    }

    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    public void run() throws SaxonApiException {
        ContentSource contentSource;
        super.run();
        String host = this.getOption(_host, "");
        int port = this.getOption(_port, 0);
        String user = this.getOption(_user, "");
        String password = this.getOption(_password, "");
        String contentBase = this.getOption(_contentBase, "");
        QName wrapper = XProcConstants.c_result;
        if (this.getOption(_wrapper) != null) {
            wrapper = this.getOption(_wrapper).getQName();
        }
        XdmNode queryDocument = this.source.read();
        String queryString = queryDocument.getStringValue();
        try {
            contentSource = "".equals(contentBase) ? ContentSourceFactory.newContentSource((String)host, (int)port, (String)user, (String)password) : ContentSourceFactory.newContentSource((String)host, (int)port, (String)user, (String)password, (String)contentBase);
        }
        catch (Exception e) {
            throw new XProcException((Throwable)e);
        }
        if ("basic".equals(this.getOption(_auth_method, ""))) {
            contentSource.setAuthenticationPreemptive(true);
        }
        try {
            Session session = contentSource.newSession();
            AdhocQuery request = session.newAdhocQuery(queryString);
            for (QName name : this.params.keySet()) {
                XSString value = ValueFactory.newXSString((String)this.params.get(name));
                XName xname = new XName(name.getNamespaceURI(), name.getLocalName());
                XdmVariable myVariable = ValueFactory.newVariable((XName)xname, (XdmValue)value);
                request.setVariable(myVariable);
            }
            ResultSequence rs = session.submitRequest((Request)request);
            while (rs.hasNext()) {
                XdmNode node;
                TreeWriter treeWriter;
                ResultItem rsItem = rs.next();
                XdmItem item = rsItem.getItem();
                if (item instanceof XdmDocument || item instanceof XdmElement) {
                    XdmNode xccXML = this.parseString(item.asString());
                    this.result.write(xccXML);
                    continue;
                }
                if (item instanceof XdmBinary) {
                    String base64 = Base64.encodeBytes((byte[])((XdmBinary)item).asBinaryData());
                    treeWriter = new TreeWriter(this.runtime);
                    treeWriter.startDocument(this.step.getNode().getBaseURI());
                    treeWriter.addStartElement(wrapper);
                    if ("http://www.w3.org/ns/xproc-step".equals(wrapper.getNamespaceURI())) {
                        treeWriter.addAttribute(_encoding, "base64");
                    } else {
                        treeWriter.addAttribute(c_encoding, "base64");
                    }
                    treeWriter.startContent();
                    treeWriter.addText(base64);
                    treeWriter.addEndElement();
                    treeWriter.endDocument();
                    node = treeWriter.getResult();
                    this.result.write(node);
                    continue;
                }
                String text = item.asString();
                treeWriter = new TreeWriter(this.runtime);
                treeWriter.startDocument(this.step.getNode().getBaseURI());
                treeWriter.addStartElement(wrapper);
                treeWriter.startContent();
                treeWriter.addText(text);
                treeWriter.addEndElement();
                treeWriter.endDocument();
                node = treeWriter.getResult();
                this.result.write(node);
            }
            session.close();
        }
        catch (Exception e) {
            throw new XProcException((Throwable)e);
        }
    }

    private XdmNode parseString(String xml) {
        StringReader sr = new StringReader(xml);
        return this.runtime.parse(new InputSource(sr));
    }
}

