/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.ws.builder.core;

import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.xml.namespace.QName;
import org.reficio.ws.SoapContext;
import org.reficio.ws.builder.SoapBuilder;
import org.reficio.ws.builder.SoapOperation;
import org.reficio.ws.builder.SoapOperationBuilder;
import org.reficio.ws.builder.core.SoapUtils;

class SoapOperationImpl
implements SoapOperation,
SoapOperationBuilder {
    private final QName bindingName;
    private final String operationName;
    private final String operationInputName;
    private final String operationOutputName;
    private final String soapAction;
    private final SoapBuilder builder;
    private SoapContext context;

    SoapOperationImpl(SoapBuilder builder, QName bindingName, String operationName, String operationInputName, String operationOutputName, String soapAction) {
        this.builder = builder;
        this.bindingName = bindingName;
        this.operationName = operationName;
        this.operationInputName = operationInputName;
        this.operationOutputName = operationOutputName;
        this.soapAction = soapAction;
        this.context = builder.getContext();
    }

    @Override
    public QName getBindingName() {
        return this.bindingName;
    }

    @Override
    public String getOperationName() {
        return this.operationName;
    }

    @Override
    public String getOperationInputName() {
        return this.operationInputName;
    }

    @Override
    public String getOperationOutputName() {
        return this.operationOutputName;
    }

    @Override
    public String getSoapAction() {
        return this.soapAction;
    }

    @Override
    public boolean isRpc() {
        return this.builder.isRpc();
    }

    @Override
    public boolean isInputSoapEncoded() {
        return this.builder.isInputSoapEncoded(this);
    }

    @Override
    public boolean isOutputSoapEncoded() {
        return this.builder.isOutputSoapEncoded(this);
    }

    static SoapOperationBuilder create(SoapBuilder builder, Binding binding, BindingOperation operation) {
        String soapAction = SoapUtils.getSOAPActionUri(operation);
        return SoapOperationImpl.create(builder, binding, operation, soapAction);
    }

    static SoapOperationBuilder create(SoapBuilder builder, Binding binding, BindingOperation operation, String soapAction) {
        String bindingInputName = operation.getBindingInput() != null ? operation.getBindingInput().getName() : null;
        String bindingOutputName = operation.getBindingOutput() != null ? operation.getBindingOutput().getName() : null;
        return new SoapOperationImpl(builder, binding.getQName(), operation.getName(), bindingInputName, bindingOutputName, SoapUtils.normalizeSoapAction(soapAction));
    }

    public String toString() {
        return String.format("bindingName=[%s] operationName=[%s] operationInputName=[%s] operationOutputName=[%s] soapAction=[%s]", this.bindingName.toString(), this.operationName, this.operationInputName, this.operationOutputName, this.soapAction);
    }

    @Override
    public void setContext(SoapContext context) {
        this.context = context;
    }

    @Override
    public SoapContext getContext() {
        return this.builder.getContext();
    }

    @Override
    public String buildInputMessage() {
        return this.builder.buildInputMessage(this, this.context);
    }

    @Override
    public String buildInputMessage(SoapContext context) {
        return this.builder.buildInputMessage(this, context);
    }

    @Override
    public String buildOutputMessage() {
        return this.builder.buildOutputMessage(this, this.context);
    }

    @Override
    public String buildOutputMessage(SoapContext context) {
        return this.builder.buildOutputMessage(this, context);
    }

    @Override
    public String buildFault(String code, String message) {
        return this.builder.buildFault(code, message, this.context);
    }

    @Override
    public String buildFault(String code, String message, SoapContext context) {
        return this.builder.buildFault(code, message, context);
    }

    @Override
    public String buildEmptyFault() {
        return this.builder.buildEmptyFault(this.context);
    }

    @Override
    public String buildEmptyFault(SoapContext context) {
        return this.builder.buildEmptyFault(context);
    }

    @Override
    public String buildEmptyMessage() {
        return this.builder.buildEmptyMessage(this.context);
    }

    @Override
    public String buildEmptyMessage(SoapContext context) {
        return this.builder.buildEmptyMessage(context);
    }

    @Override
    public void validateInputMessage(String message) {
        this.builder.validateInputMessage(this, message);
    }

    @Override
    public void validateInputMessage(String message, boolean strict) {
        this.builder.validateInputMessage(this, message, strict);
    }

    @Override
    public void validateOutputMessage(String message) {
        this.builder.validateOutputMessage(this, message);
    }

    @Override
    public void validateOutputMessage(String message, boolean strict) {
        this.builder.validateOutputMessage(this, message, strict);
    }
}

