/*
 * Decompiled with CFR 0.152.
 */
package com.sivin;

import android.content.Context;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import com.sivin.SLooperAdapter;
import java.util.ArrayList;
import java.util.List;

public class SLooperViewPager
extends ViewPager {
    private SLooperAdapter mAdapter;
    private List<ViewPager.OnPageChangeListener> mOnPageChangeListeners;
    private ViewPager.OnPageChangeListener mOnPageChangeListener = new ViewPager.OnPageChangeListener(){
        private float mPreviousOffset = -1.0f;
        private float mPreviousPosition = -1.0f;

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            if (SLooperViewPager.this.mAdapter != null) {
                int innerPosition = SLooperViewPager.this.mAdapter.getInnerAdapterPosition(position);
                if (positionOffset == 0.0f && this.mPreviousOffset == 0.0f && (position == 0 || position == SLooperViewPager.this.mAdapter.getCount() - 1)) {
                    SLooperViewPager.this.setCurrentItem(innerPosition, false);
                }
                this.mPreviousOffset = positionOffset;
                if (SLooperViewPager.this.mOnPageChangeListeners != null) {
                    for (int i = 0; i < SLooperViewPager.this.mOnPageChangeListeners.size(); ++i) {
                        ViewPager.OnPageChangeListener listener = (ViewPager.OnPageChangeListener)SLooperViewPager.this.mOnPageChangeListeners.get(i);
                        if (listener == null) continue;
                        if (innerPosition != SLooperViewPager.this.mAdapter.getInnerCount() - 1) {
                            listener.onPageScrolled(innerPosition, positionOffset, positionOffsetPixels);
                            continue;
                        }
                        if ((double)positionOffset > 0.5) {
                            listener.onPageScrolled(0, 0.0f, 0);
                            continue;
                        }
                        listener.onPageScrolled(innerPosition, 0.0f, 0);
                    }
                }
            }
        }

        public void onPageSelected(int position) {
            int realPosition = SLooperViewPager.this.mAdapter.getInnerAdapterPosition(position);
            if (this.mPreviousPosition != (float)realPosition) {
                this.mPreviousPosition = realPosition;
                if (SLooperViewPager.this.mOnPageChangeListeners != null) {
                    for (int i = 0; i < SLooperViewPager.this.mOnPageChangeListeners.size(); ++i) {
                        ViewPager.OnPageChangeListener listener = (ViewPager.OnPageChangeListener)SLooperViewPager.this.mOnPageChangeListeners.get(i);
                        if (listener == null) continue;
                        listener.onPageSelected(realPosition);
                    }
                }
            }
        }

        public void onPageScrollStateChanged(int state) {
            if (SLooperViewPager.this.mAdapter != null) {
                int position = SLooperViewPager.super.getCurrentItem();
                int realPosition = SLooperViewPager.this.mAdapter.getInnerAdapterPosition(position);
                if (state == 0 && (position == 0 || position == SLooperViewPager.this.mAdapter.getCount() - 1)) {
                    SLooperViewPager.this.setCurrentItem(realPosition, false);
                }
            }
            if (SLooperViewPager.this.mOnPageChangeListeners != null) {
                for (int i = 0; i < SLooperViewPager.this.mOnPageChangeListeners.size(); ++i) {
                    ViewPager.OnPageChangeListener listener = (ViewPager.OnPageChangeListener)SLooperViewPager.this.mOnPageChangeListeners.get(i);
                    if (listener == null) continue;
                    listener.onPageScrollStateChanged(state);
                }
            }
        }
    };

    public SLooperViewPager(Context context) {
        this(context, null);
    }

    public SLooperViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public void setAdapter(PagerAdapter adapter) {
        this.mAdapter = new SLooperAdapter(adapter);
        super.setAdapter((PagerAdapter)this.mAdapter);
        this.setCurrentItem(0, false);
    }

    public PagerAdapter getAdapter() {
        return this.mAdapter;
    }

    public void setCurrentItem(int item) {
        this.setCurrentItem(item, true);
    }

    public void setCurrentItem(int position, boolean smoothScroll) {
        super.setCurrentItem(this.mAdapter.toLooperPosition(position), smoothScroll);
    }

    public int getCurrentItem() {
        return this.mAdapter.getInnerAdapterPosition(super.getCurrentItem());
    }

    public void clearOnPageChangeListeners() {
        if (this.mOnPageChangeListeners != null) {
            this.mOnPageChangeListeners.clear();
        }
    }

    public void removeOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        if (this.mOnPageChangeListeners != null) {
            this.mOnPageChangeListeners.remove(listener);
        }
    }

    public void addOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        if (this.mOnPageChangeListeners == null) {
            this.mOnPageChangeListeners = new ArrayList<ViewPager.OnPageChangeListener>();
        }
        this.mOnPageChangeListeners.add(listener);
    }

    private void init(Context context) {
        if (this.mOnPageChangeListener != null) {
            super.removeOnPageChangeListener(this.mOnPageChangeListener);
        }
        super.addOnPageChangeListener(this.mOnPageChangeListener);
    }
}

