/*
 * Decompiled with CFR 0.152.
 */
package com.sivin;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.SparseArray;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.sivin.BannerAdapter;
import com.sivin.SLooperViewPager;
import com.sivin.ViewPagerScroller;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import sivin.com.banner.R;

public class Banner
extends RelativeLayout {
    private static final String TAG = Banner.class.getSimpleName();
    private Context mContext;
    private SparseArray<ImageView> mItemArrays;
    private static final int RMP = -1;
    private static final int RWC = -2;
    private static final int LWC = -2;
    private SLooperViewPager mViewPager;
    private TextView mTipTextView;
    private int mTipTextSize;
    private int mTipTextColor = -1;
    private LinearLayout mPointContainerLl;
    private int mPointDrawableResId = R.drawable.selector_banner_point;
    private int mPointGravity = 81;
    private int mPointLeftRightMargin;
    private int mPointTopBottomMargin;
    private int mPointContainerLeftRightPadding;
    private Drawable mPointContainerBackgroundDrawable;
    protected List mData = new ArrayList();
    private int mAutoPlayInterval = 3;
    private int mPageChangeDuration = 800;
    private boolean mPlaying = false;
    protected int currentPosition;
    private BannerAdapter mBannerAdapter;
    protected ScheduledExecutorService mExecutor;
    private Handler mPlayHandler = new PlayHandler(this);
    private OnBannerItemClickListener onVpItemClickListener;

    public Banner(Context context) {
        this(context, null);
    }

    public Banner(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public Banner(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initDefaultAttrs(context);
        this.initCustomAttrs(context, attrs);
        this.initView(context);
    }

    private void initDefaultAttrs(Context context) {
        this.mPointLeftRightMargin = this.dp2px(context, 3.0f);
        this.mPointTopBottomMargin = this.dp2px(context, 6.0f);
        this.mPointContainerLeftRightPadding = this.dp2px(context, 10.0f);
        this.mTipTextSize = this.sp2px(context, 8.0f);
        this.mPointContainerBackgroundDrawable = new ColorDrawable(Color.parseColor((String)"#33aaaaaa"));
    }

    private int dp2px(Context context, float dpValue) {
        return (int)TypedValue.applyDimension((int)1, (float)dpValue, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    private int sp2px(Context context, float spValue) {
        return (int)TypedValue.applyDimension((int)2, (float)spValue, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    private void initCustomAttrs(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.SivinBanner);
        int N = typedArray.getIndexCount();
        for (int i = 0; i < N; ++i) {
            this.initCustomAttr(typedArray.getIndex(i), typedArray);
        }
        typedArray.recycle();
    }

    private void initCustomAttr(int attr, TypedArray typedArray) {
        if (attr == R.styleable.SivinBanner_banner_pointDrawable) {
            this.mPointDrawableResId = typedArray.getResourceId(attr, R.drawable.selector_banner_point);
        } else if (attr == R.styleable.SivinBanner_banner_pointContainerBackground) {
            this.mPointContainerBackgroundDrawable = typedArray.getDrawable(attr);
        } else if (attr == R.styleable.SivinBanner_banner_pointLeftRightMargin) {
            this.mPointLeftRightMargin = typedArray.getDimensionPixelSize(attr, this.mPointLeftRightMargin);
        } else if (attr == R.styleable.SivinBanner_banner_pointContainerLeftRightPadding) {
            this.mPointContainerLeftRightPadding = typedArray.getDimensionPixelSize(attr, this.mPointContainerLeftRightPadding);
        } else if (attr == R.styleable.SivinBanner_banner_pointTopBottomMargin) {
            this.mPointTopBottomMargin = typedArray.getDimensionPixelSize(attr, this.mPointTopBottomMargin);
        } else if (attr == R.styleable.SivinBanner_banner_pointGravity) {
            this.mPointGravity = typedArray.getInt(attr, this.mPointGravity);
        } else if (attr == R.styleable.SivinBanner_banner_pointAutoPlayInterval) {
            this.mAutoPlayInterval = typedArray.getInteger(attr, this.mAutoPlayInterval);
        } else if (attr == R.styleable.SivinBanner_banner_pageChangeDuration) {
            this.mPageChangeDuration = typedArray.getInteger(attr, this.mPageChangeDuration);
        } else if (attr == R.styleable.SivinBanner_banner_tipTextColor) {
            this.mTipTextColor = typedArray.getColor(attr, this.mTipTextColor);
        } else if (attr == R.styleable.SivinBanner_banner_tipTextSize) {
            this.mTipTextSize = typedArray.getDimensionPixelSize(attr, this.mTipTextSize);
        }
    }

    private void initView(Context context) {
        this.mContext = context;
        this.mItemArrays = new SparseArray();
        this.mViewPager = new SLooperViewPager(context);
        this.addView((View)this.mViewPager, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        this.mPageChangeDuration = this.mPageChangeDuration > this.mAutoPlayInterval * 1000 ? this.mAutoPlayInterval * 1000 : this.mPageChangeDuration;
        ViewPagerScroller pagerScroller = new ViewPagerScroller(this.mContext);
        pagerScroller.changScrollDuration(this.mViewPager, this.mPageChangeDuration);
        RelativeLayout indicatorContainerRl = new RelativeLayout(context);
        if (Build.VERSION.SDK_INT >= 16) {
            indicatorContainerRl.setBackground(this.mPointContainerBackgroundDrawable);
        } else {
            indicatorContainerRl.setBackgroundDrawable(this.mPointContainerBackgroundDrawable);
        }
        indicatorContainerRl.setPadding(this.mPointContainerLeftRightPadding, 0, this.mPointContainerLeftRightPadding, 0);
        RelativeLayout.LayoutParams indicatorContainerLp = new RelativeLayout.LayoutParams(-1, -2);
        if ((this.mPointGravity & 0x70) == 48) {
            indicatorContainerLp.addRule(10);
        } else {
            indicatorContainerLp.addRule(12);
        }
        this.addView((View)indicatorContainerRl, (ViewGroup.LayoutParams)indicatorContainerLp);
        this.mPointContainerLl = new LinearLayout(context);
        this.mPointContainerLl.setId(R.id.banner_pointContainerId);
        this.mPointContainerLl.setOrientation(0);
        RelativeLayout.LayoutParams pointContainerLp = new RelativeLayout.LayoutParams(-2, -2);
        indicatorContainerRl.addView((View)this.mPointContainerLl, (ViewGroup.LayoutParams)pointContainerLp);
        RelativeLayout.LayoutParams tipLp = new RelativeLayout.LayoutParams(-1, this.getResources().getDrawable(this.mPointDrawableResId).getIntrinsicHeight() + 2 * this.mPointTopBottomMargin);
        this.mTipTextView = new TextView(context);
        this.mTipTextView.setGravity(16);
        this.mTipTextView.setSingleLine(true);
        this.mTipTextView.setEllipsize(TextUtils.TruncateAt.END);
        this.mTipTextView.setTextColor(this.mTipTextColor);
        this.mTipTextView.setTextSize(0, (float)this.mTipTextSize);
        indicatorContainerRl.addView((View)this.mTipTextView, (ViewGroup.LayoutParams)tipLp);
        int horizontalGravity = this.mPointGravity & 7;
        if (horizontalGravity == 3) {
            pointContainerLp.addRule(9);
            tipLp.addRule(1, R.id.banner_pointContainerId);
            this.mTipTextView.setGravity(21);
        } else if (horizontalGravity == 5) {
            pointContainerLp.addRule(11);
            tipLp.addRule(0, R.id.banner_pointContainerId);
        } else {
            pointContainerLp.addRule(14);
            tipLp.addRule(0, R.id.banner_pointContainerId);
        }
    }

    private void initPoints() {
        int childCount = this.mPointContainerLl.getChildCount();
        int dataSize = this.mData.size();
        int offset = dataSize - childCount;
        if (offset == 0) {
            return;
        }
        if (offset > 0) {
            LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-2, -2);
            lp.setMargins(this.mPointLeftRightMargin, this.mPointTopBottomMargin, this.mPointLeftRightMargin, this.mPointTopBottomMargin);
            for (int i = 0; i < offset; ++i) {
                ImageView imageView = new ImageView(this.getContext());
                imageView.setLayoutParams((ViewGroup.LayoutParams)lp);
                imageView.setImageResource(this.mPointDrawableResId);
                imageView.setEnabled(false);
                this.mPointContainerLl.addView((View)imageView);
            }
            return;
        }
        if (offset < 0) {
            this.mPointContainerLl.removeViews(dataSize, -offset);
        }
    }

    private void switchToPoint(int newCurrentPoint) {
        for (int i = 0; i < this.mPointContainerLl.getChildCount(); ++i) {
            this.mPointContainerLl.getChildAt(i).setEnabled(false);
        }
        this.mPointContainerLl.getChildAt(newCurrentPoint).setEnabled(true);
        if (this.mTipTextView != null) {
            this.mBannerAdapter.selectTips(this.mTipTextView, this.currentPosition);
        }
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        int action = ev.getAction();
        switch (action) {
            case 0: {
                this.pauseScroll();
                break;
            }
            case 1: {
                this.goScroll();
                break;
            }
            case 3: {
                this.goScroll();
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    public void setPageChangeDuration(int duration) {
        this.mPageChangeDuration = duration;
    }

    private void scrollToNextItem(int position) {
        this.mViewPager.setCurrentItem(++position, true);
    }

    private ImageView createItemView(int position) {
        ImageView iv = new ImageView(this.mContext);
        iv.setScaleType(ImageView.ScaleType.CENTER_CROP);
        this.mItemArrays.put(position, (Object)iv);
        return iv;
    }

    public void setOnBannerItemClickListener(OnBannerItemClickListener listener) {
        this.onVpItemClickListener = listener;
    }

    private void goScroll() {
        if (!this.isValid()) {
            return;
        }
        if (this.mPlaying) {
            return;
        }
        this.pauseScroll();
        this.mExecutor = Executors.newSingleThreadScheduledExecutor();
        this.mExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                Banner.this.mPlayHandler.obtainMessage().sendToTarget();
            }
        }, this.mAutoPlayInterval, this.mAutoPlayInterval, TimeUnit.SECONDS);
        this.mPlaying = true;
    }

    public void pauseScroll() {
        if (this.mExecutor != null) {
            this.mExecutor.shutdown();
            this.mExecutor = null;
        }
        this.mPlaying = false;
    }

    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (visibility == 0) {
            this.goScroll();
        } else if (visibility == 4) {
            this.pauseScroll();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.pauseScroll();
    }

    private boolean isValid() {
        if (this.mViewPager == null) {
            Log.e((String)TAG, (String)"ViewPager is not exist!");
            return false;
        }
        if (this.mData == null || this.mData.size() == 0) {
            Log.e((String)TAG, (String)"DataList must be not empty!");
            return false;
        }
        return true;
    }

    private void setSource() {
        List list = this.mBannerAdapter.getDatas();
        if (list == null) {
            Log.d((String)TAG, (String)"setSource: list==null");
            return;
        }
        this.mData = list;
        this.setAdapter();
    }

    private void setAdapter() {
        this.mViewPager.setAdapter(new InnerPagerAdapter());
        this.mViewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)new ChangePointListener());
    }

    public void setBannerAdapter(BannerAdapter adapter) {
        this.mBannerAdapter = adapter;
        this.setSource();
    }

    public void notifiDataHasChanged() {
        this.initPoints();
        this.mViewPager.getAdapter().notifyDataSetChanged();
        this.mViewPager.setCurrentItem(0, false);
        if (this.mData.size() > 1) {
            this.goScroll();
        }
    }

    static class PlayHandler
    extends Handler {
        WeakReference<Banner> mWeakBanner;

        public PlayHandler(Banner banner) {
            this.mWeakBanner = new WeakReference<Banner>(banner);
        }

        public void handleMessage(Message msg) {
            Banner weakBanner = (Banner)((Object)this.mWeakBanner.get());
            if (weakBanner != null) {
                weakBanner.scrollToNextItem(weakBanner.currentPosition);
            }
        }
    }

    public static interface OnBannerItemClickListener {
        public void onItemClick(int var1);
    }

    private final class InnerPagerAdapter
    extends PagerAdapter {
        private InnerPagerAdapter() {
        }

        public int getCount() {
            return Banner.this.mData.size();
        }

        public Object instantiateItem(ViewGroup container, final int position) {
            ImageView view = Banner.this.createItemView(position);
            Banner.this.mBannerAdapter.setImageViewSource(view, position);
            view.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (Banner.this.onVpItemClickListener != null) {
                        Banner.this.onVpItemClickListener.onItemClick(position);
                    }
                }
            });
            container.addView((View)view);
            return view;
        }

        public void destroyItem(ViewGroup container, int position, Object object) {
            container.removeView((View)object);
        }

        public boolean isViewFromObject(View view, Object object) {
            return view == object;
        }

        public int getItemPosition(Object object) {
            return -2;
        }
    }

    private final class ChangePointListener
    extends ViewPager.SimpleOnPageChangeListener {
        private ChangePointListener() {
        }

        public void onPageSelected(int position) {
            Banner.this.currentPosition = position % Banner.this.mData.size();
            Banner.this.switchToPoint(Banner.this.currentPosition);
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            if (Banner.this.mTipTextView != null) {
                if ((double)positionOffset > 0.5) {
                    Banner.this.mBannerAdapter.selectTips(Banner.this.mTipTextView, Banner.this.currentPosition);
                    Banner.this.mTipTextView.setAlpha(positionOffset);
                } else {
                    Banner.this.mTipTextView.setAlpha(1.0f - positionOffset);
                    Banner.this.mBannerAdapter.selectTips(Banner.this.mTipTextView, Banner.this.currentPosition);
                }
            }
        }
    }
}

