/*
 * Decompiled with CFR 0.152.
 */
package com.xingyuv.http.support.okhttp3;

import com.xingyuv.http.config.HttpConfig;
import com.xingyuv.http.support.AbstractHttp;
import com.xingyuv.http.support.HttpHeader;
import com.xingyuv.http.support.SimpleHttpResponse;
import com.xingyuv.http.util.MapUtil;
import com.xingyuv.http.util.StringUtil;
import java.time.Duration;
import java.util.Map;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class OkHttp3Impl
extends AbstractHttp {
    public static final MediaType CONTENT_TYPE_JSON = MediaType.get((String)"application/json; charset=utf-8");
    private final OkHttpClient.Builder httpClientBuilder;

    public OkHttp3Impl() {
        this(new HttpConfig());
    }

    public OkHttp3Impl(HttpConfig httpConfig) {
        this(new OkHttpClient().newBuilder(), httpConfig);
    }

    public OkHttp3Impl(OkHttpClient.Builder httpClientBuilder, HttpConfig httpConfig) {
        super(httpConfig);
        this.httpClientBuilder = httpClientBuilder;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SimpleHttpResponse exec(Request.Builder requestBuilder) {
        this.addHeader(requestBuilder);
        Request request = requestBuilder.build();
        OkHttpClient httpClient = null != this.httpConfig.getProxy() ? this.httpClientBuilder.connectTimeout(Duration.ofMillis(this.httpConfig.getTimeout())).writeTimeout(Duration.ofMillis(this.httpConfig.getTimeout())).readTimeout(Duration.ofMillis(this.httpConfig.getTimeout())).proxy(this.httpConfig.getProxy()).build() : this.httpClientBuilder.connectTimeout(Duration.ofMillis(this.httpConfig.getTimeout())).writeTimeout(Duration.ofMillis(this.httpConfig.getTimeout())).readTimeout(Duration.ofMillis(this.httpConfig.getTimeout())).build();
        try (Response response = httpClient.newCall(request).execute();){
            int code = response.code();
            boolean successful = response.isSuccessful();
            Map headers = response.headers().toMultimap();
            ResponseBody responseBody = response.body();
            String body = null == responseBody ? null : responseBody.string();
            SimpleHttpResponse simpleHttpResponse = new SimpleHttpResponse(successful, code, headers, body, null);
            return simpleHttpResponse;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new SimpleHttpResponse(false, 500, null, null, e.getMessage());
        }
    }

    private void addHeader(Request.Builder builder) {
        builder.header("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/75.0.3770.142 Safari/537.36 simple-http");
    }

    @Override
    public SimpleHttpResponse get(String url) {
        return this.get(url, null, false);
    }

    @Override
    public SimpleHttpResponse get(String url, Map<String, String> params, boolean encode) {
        return this.get(url, params, null, encode);
    }

    @Override
    public SimpleHttpResponse get(String url, Map<String, String> params, HttpHeader header, boolean encode) {
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)url).newBuilder();
        if (encode) {
            MapUtil.forEach(params, (arg_0, arg_1) -> ((HttpUrl.Builder)urlBuilder).addEncodedQueryParameter(arg_0, arg_1));
        } else {
            MapUtil.forEach(params, (arg_0, arg_1) -> ((HttpUrl.Builder)urlBuilder).addQueryParameter(arg_0, arg_1));
        }
        HttpUrl httpUrl = urlBuilder.build();
        Request.Builder requestBuilder = new Request.Builder().url(httpUrl);
        if (header != null) {
            MapUtil.forEach(header.getHeaders(), (arg_0, arg_1) -> ((Request.Builder)requestBuilder).addHeader(arg_0, arg_1));
        }
        requestBuilder = requestBuilder.get();
        return this.exec(requestBuilder);
    }

    @Override
    public SimpleHttpResponse post(String url) {
        return this.post(url, "");
    }

    @Override
    public SimpleHttpResponse post(String url, String data) {
        return this.post(url, data, null);
    }

    @Override
    public SimpleHttpResponse post(String url, String data, HttpHeader header) {
        if (StringUtil.isEmpty(data)) {
            data = "";
        }
        RequestBody body = RequestBody.create((String)data, (MediaType)CONTENT_TYPE_JSON);
        Request.Builder requestBuilder = new Request.Builder().url(url);
        if (header != null) {
            MapUtil.forEach(header.getHeaders(), (arg_0, arg_1) -> ((Request.Builder)requestBuilder).addHeader(arg_0, arg_1));
        }
        requestBuilder = requestBuilder.post(body);
        return this.exec(requestBuilder);
    }

    @Override
    public SimpleHttpResponse post(String url, Map<String, String> params, boolean encode) {
        return this.post(url, params, null, encode);
    }

    @Override
    public SimpleHttpResponse post(String url, Map<String, String> params, HttpHeader header, boolean encode) {
        FormBody.Builder formBuilder = new FormBody.Builder();
        if (encode) {
            MapUtil.forEach(params, (arg_0, arg_1) -> ((FormBody.Builder)formBuilder).addEncoded(arg_0, arg_1));
        } else {
            MapUtil.forEach(params, (arg_0, arg_1) -> ((FormBody.Builder)formBuilder).add(arg_0, arg_1));
        }
        FormBody body = formBuilder.build();
        Request.Builder requestBuilder = new Request.Builder().url(url);
        if (header != null) {
            MapUtil.forEach(header.getHeaders(), (arg_0, arg_1) -> ((Request.Builder)requestBuilder).addHeader(arg_0, arg_1));
        }
        requestBuilder = requestBuilder.post((RequestBody)body);
        return this.exec(requestBuilder);
    }
}

