/*
 * Decompiled with CFR 0.152.
 */
package com.xiaosu.lib.permission;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AlertDialog;
import android.support.v7.view.ContextThemeWrapper;
import android.text.TextUtils;
import android.util.SparseBooleanArray;
import com.xiaosu.lib.permission.PermissionCompat;
import com.xiaosu.lib.permission.R;

public class RequestFragment
extends Fragment {
    private String[] mExplain;
    private String[] mPermissions;
    private boolean isNewActivity;
    private boolean mRetry;
    private SparseBooleanArray retryArr = new SparseBooleanArray();

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.initData();
        this.checkPermission();
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (this.checkPermission(this.mPermissions[requestCode])) {
            this.checkPermission();
        } else {
            this.onDeny(requestCode);
        }
    }

    private void initData() {
        Bundle extras = this.getArguments();
        this.mExplain = extras.getStringArray("explain");
        this.mRetry = extras.getBoolean("retry");
        this.isNewActivity = extras.getBoolean("new_activity", true);
        this.mPermissions = extras.getStringArray("permissions");
    }

    private void checkPermission() {
        int index = this.checkPermissions(this.mPermissions);
        if (index != -1) {
            if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)this.getActivity(), (String)this.mPermissions[index]) && null != this.mExplain && !TextUtils.isEmpty((CharSequence)this.mExplain[index])) {
                this.explain(this.mExplain[index], this.mPermissions[index], index);
            } else {
                this.requestPermission(this.mPermissions[index], index);
            }
        } else {
            this.onGrant();
        }
    }

    private void onDeny(int index) {
        boolean shouldExplain = ActivityCompat.shouldShowRequestPermissionRationale((Activity)this.getActivity(), (String)this.mPermissions[index]);
        if (shouldExplain) {
            if (this.mRetry && null != this.mExplain && !TextUtils.isEmpty((CharSequence)this.mExplain[index]) && this.retryArr.get(index, true)) {
                this.explain(this.mExplain[index], this.mPermissions[index], index);
            } else {
                this.onRealDeny(this.mPermissions[index], true);
            }
        } else {
            this.onRealDeny(this.mPermissions[index], false);
        }
    }

    private void onRealDeny(String permission, boolean canRequestAgain) {
        PermissionCompat.notifyOnDenyCallback(permission, canRequestAgain);
        this.finish();
    }

    private void onGrant() {
        PermissionCompat.notifyOnGrantCallback();
        this.finish();
    }

    @TargetApi(value=23)
    private void requestPermission(String permission, int index) {
        this.requestPermissions(new String[]{permission}, index);
    }

    private int checkPermissions(String[] permissions) {
        for (int i = 0; i < permissions.length; ++i) {
            if (this.checkPermission(permissions[i])) continue;
            return i;
        }
        return -1;
    }

    private boolean checkPermission(String permission) {
        return ContextCompat.checkSelfPermission((Context)this.getActivity(), (String)permission) == 0;
    }

    public static RequestFragment newInstance(String[] permissions, String[] explains, boolean retry, boolean newActivity) {
        Bundle args = new Bundle();
        args.putStringArray("permissions", permissions);
        args.putStringArray("explain", explains);
        args.putBoolean("retry", retry);
        args.putBoolean("new_activity", newActivity);
        RequestFragment fragment = new RequestFragment();
        fragment.setArguments(args);
        return fragment;
    }

    public static RequestFragment newInstance(Bundle args) {
        RequestFragment fragment = new RequestFragment();
        fragment.setArguments(args);
        return fragment;
    }

    private void explain(String explain, final String permission, final int index) {
        this.retryArr.put(index, false);
        new AlertDialog.Builder((Context)new ContextThemeWrapper((Context)this.getActivity(), R.style.DialogStyle)).setMessage((CharSequence)explain).setPositiveButton(R.string.sure, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                RequestFragment.this.requestPermission(permission, index);
            }
        }).setNegativeButton(R.string.cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                RequestFragment.this.onRealDeny(permission, true);
            }
        }).show().setCancelable(false);
    }

    private void finish() {
        this.retryArr.clear();
        if (this.isNewActivity) {
            this.getActivity().finish();
        }
    }

    public void request(String[] permissions, String[] explains, boolean retry) {
        this.mPermissions = permissions;
        this.mExplain = explains;
        this.mRetry = retry;
        this.checkPermission();
    }
}

