/*
 * Decompiled with CFR 0.152.
 */
package com.xiaosu.lib.permission;

import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.util.SparseArray;
import com.xiaosu.lib.permission.OnRequestPermissionsCallBack;
import com.xiaosu.lib.permission.RequestActivity;
import com.xiaosu.lib.permission.RequestFragment;
import com.xiaosu.lib.permission.annotation.OnDeny;
import com.xiaosu.lib.permission.annotation.OnGrant;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class PermissionCompat {
    private static OnRequestPermissionsCallBack sCallBack;
    private static Object sTarget;
    private static int sId;
    private Builder mBuilder;

    private PermissionCompat(Builder builder) {
        this.mBuilder = builder;
    }

    public void request() {
        if (Build.VERSION.SDK_INT < 23) {
            for (String p : this.mBuilder.mPermissions) {
                PackageManager pm = this.mBuilder.mContext.getPackageManager();
                if (-1 != pm.checkPermission(p, this.mBuilder.mContext.getPackageName())) continue;
                throw new RuntimeException("\u8bf7\u5728AndroidManifest.xml\u6587\u4ef6\u4e2d\u914d\u7f6e [ " + p + " ] \u6743\u9650");
            }
            PermissionCompat.notifyOnGrantCallback();
            return;
        }
        int length = this.mBuilder.mPermissions.length;
        String[] explains = new String[length];
        int size = this.mBuilder.sia.size();
        for (int i = 0; i < size; ++i) {
            String explain;
            int index = this.mBuilder.sia.keyAt(i);
            if (index >= length) {
                throw new ArrayIndexOutOfBoundsException(index);
            }
            explains[index] = explain = (String)this.mBuilder.sia.valueAt(i);
        }
        if (this.mBuilder.mContext instanceof Activity) {
            Activity fa = (Activity)this.mBuilder.mContext;
            FragmentManager manager = fa.getFragmentManager();
            Fragment fragment = manager.findFragmentByTag("REQUEST_FRAGMENT");
            if (null != fragment && fragment instanceof RequestFragment) {
                RequestFragment f = (RequestFragment)fragment;
                f.request(this.mBuilder.mPermissions, explains, this.mBuilder.retry);
            } else {
                manager.beginTransaction().add((Fragment)RequestFragment.newInstance(this.mBuilder.mPermissions, explains, this.mBuilder.retry, false), "REQUEST_FRAGMENT").commitAllowingStateLoss();
            }
            manager.executePendingTransactions();
        } else {
            RequestActivity.go(this.mBuilder.mContext, this.mBuilder.mPermissions, this.mBuilder.retry, explains);
        }
    }

    static void notifyOnGrantCallback() {
        if (null != sCallBack) {
            sCallBack.onGrant();
            sCallBack = null;
        } else if (null != sTarget) {
            Method[] methods;
            for (Method m : methods = sTarget.getClass().getDeclaredMethods()) {
                int[] values;
                OnGrant onGrant;
                if (!Modifier.isPublic(m.getModifiers()) || null == (onGrant = m.getAnnotation(OnGrant.class)) || !PermissionCompat.hasValue(values = onGrant.value(), sId)) continue;
                try {
                    m.invoke(sTarget, new Object[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
        }
        PermissionCompat.releaseReference();
    }

    static void notifyOnDenyCallback(String permission, boolean retry) {
        if (null != sCallBack) {
            sCallBack.onDenied(permission, retry);
        } else if (null != sTarget) {
            Method[] methods;
            for (Method m : methods = sTarget.getClass().getDeclaredMethods()) {
                int[] values;
                OnDeny onDeny;
                if (!Modifier.isPublic(m.getModifiers()) || null == (onDeny = m.getAnnotation(OnDeny.class)) || !PermissionCompat.hasValue(values = onDeny.value(), sId)) continue;
                try {
                    m.invoke(sTarget, permission, retry);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
        }
        PermissionCompat.releaseReference();
    }

    private static boolean hasValue(int[] values, int value) {
        for (int v : values) {
            if (v != value) continue;
            return true;
        }
        return false;
    }

    private static void releaseReference() {
        sCallBack = null;
        sTarget = null;
        sId = 0;
    }

    public static Builder create(Context context) {
        return new Builder(context);
    }

    public static class Builder2 {
        Builder mBuilder;

        Builder2(Builder builder) {
            this.mBuilder = builder;
        }

        public Builder2 callBack(Object cb, int id) {
            sTarget = cb;
            sId = id;
            return this;
        }

        public PermissionCompat build() {
            return this.mBuilder.build();
        }
    }

    public static class Builder {
        private final Context mContext;
        private SparseArray<String> sia = new SparseArray();
        private String[] mPermissions;
        private boolean retry;

        Builder(Context context) {
            this.mContext = context;
        }

        public Builder explain(int index, String describe) {
            this.sia.put(index, (Object)describe);
            return this;
        }

        public Builder explain(String ... explains) {
            int length = explains.length;
            for (int i = 0; i < length; ++i) {
                this.sia.put(i, (Object)explains[i]);
            }
            return this;
        }

        public Builder permissions(String ... permissions) {
            this.mPermissions = permissions;
            return this;
        }

        public Builder retry(boolean retry) {
            this.retry = retry;
            return this;
        }

        public Builder callBack(OnRequestPermissionsCallBack callBack) {
            sCallBack = callBack;
            return this;
        }

        public Builder2 compactCallBack(Object cb, int id) {
            if (null != sCallBack) {
                throw new RuntimeException("\u5df2\u7ecf\u8c03\u7528\u4e86callBack\u65b9\u6cd5\uff0c\u4e0d\u80fd\u518d\u8c03\u7528callBack2\u65b9\u6cd5\uff0c\u53ea\u80fd\u540c\u65f6\u5b58\u5728\u4e00\u4e2a\u56de\u8c03");
            }
            return new Builder2(this).callBack(cb, id);
        }

        public PermissionCompat build() {
            if (null == this.mPermissions) {
                throw new RuntimeException("\u8bf7\u6dfb\u52a0\u7533\u8bf7\u6743\u9650");
            }
            return new PermissionCompat(this);
        }
    }
}

