/*
 * Decompiled with CFR 0.152.
 */
package com.xiaochencode.percentprogressbar;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import com.xiaochencode.percentprogressbar.HorizontalProgressBar;
import com.xiaochencode.percentprogressbar.R;

public class RoundedProgressBar
extends HorizontalProgressBar {
    private int mRadius = (int)this.dp2px(30.0f);
    private int mMaxPaintWidth;
    private RectF mRectF;

    public RoundedProgressBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mReachHeight = this.mUnReachHeight * 2.0f;
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.RoundedProgressBar);
        this.mRadius = (int)ta.getDimension(R.styleable.RoundedProgressBar_progress_radius, (float)this.mRadius);
        ta.recycle();
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setAntiAlias(true);
        this.mPaint.setDither(true);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
    }

    @Override
    protected synchronized void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.mMaxPaintWidth = (int)Math.max(this.mReachHeight, this.mUnReachHeight);
        int expect = this.mRadius * 2 + this.mMaxPaintWidth + this.getPaddingLeft() + this.getPaddingRight();
        int width = RoundedProgressBar.resolveSize((int)expect, (int)widthMeasureSpec);
        int height = RoundedProgressBar.resolveSize((int)expect, (int)heightMeasureSpec);
        int realWidth = Math.min(width, height);
        this.mRadius = (realWidth - this.getPaddingRight() - this.getPaddingLeft() - this.mMaxPaintWidth) / 2;
        this.mRectF = new RectF(0.0f, 0.0f, (float)(this.mRadius * 2), (float)(this.mRadius * 2));
        this.setMeasuredDimension(realWidth, realWidth);
    }

    @Override
    protected synchronized void onDraw(Canvas canvas) {
        String text = this.getProgress() + "%";
        float textWidth = this.mPaint.measureText(text);
        float textHeight = this.mPaint.descent() + this.mPaint.ascent();
        canvas.save();
        canvas.translate((float)(this.getPaddingLeft() + this.mMaxPaintWidth / 2), (float)(this.getPaddingTop() + this.mMaxPaintWidth / 2));
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setColor(this.mUnReachColor);
        this.mPaint.setStrokeWidth(this.mUnReachHeight);
        canvas.drawCircle((float)this.mRadius, (float)this.mRadius, (float)this.mRadius, this.mPaint);
        this.mPaint.setColor(this.mReachColor);
        this.mPaint.setStrokeWidth(this.mReachHeight);
        float sweepAngle = (float)this.getProgress() * 1.0f / (float)this.getMax() * 360.0f;
        canvas.drawArc(this.mRectF, 0.0f, sweepAngle, false, this.mPaint);
        this.mPaint.setColor(this.mTextColor);
        this.mPaint.setStyle(Paint.Style.FILL);
        canvas.drawText(text, (float)this.mRadius - textWidth / 2.0f, (float)this.mRadius - textHeight / 2.0f, this.mPaint);
        canvas.restore();
    }

    public RoundedProgressBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RoundedProgressBar(Context context) {
        this(context, null);
    }
}

