package com.xiaochencode.percentprogressbar;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.widget.ProgressBar;

/**
 * Created by chenguang on 16/5/21.
 */
public class HorizontalProgressBar extends ProgressBar {

    private final int DEFAULT_REACH_COLOR = 0x3498DB;
    private final int DEFAULT_UNREACH_COLOR = 0xCCCCCC;
    private final float DEFAULT_REACH_HEIGHT = dp2px(1.5f);
    private final float DEFAULT_UNREACH_HEIGHT = dp2px(0.75f);
    private final float DEFAULT_TEXT_SIZE = sp2px(10f);
    private final int DEFAULT_TEXT_COLOR = 0x3498DB;
    private final float DEFAULT_TEXT_OFFSET = dp2px(1f);

    protected int mReachColor = DEFAULT_REACH_COLOR;
    protected int mUnReachColor = DEFAULT_UNREACH_COLOR;
    protected int mTextColor = DEFAULT_TEXT_COLOR;
    protected float mReachHeight = DEFAULT_REACH_HEIGHT;
    protected float mUnReachHeight = DEFAULT_UNREACH_HEIGHT;
    protected float mTextSize = DEFAULT_TEXT_SIZE;
    protected float mTextOffset = DEFAULT_TEXT_OFFSET;

    protected Paint mPaint = new Paint();
    private int mRealWidth;

    public HorizontalProgressBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public HorizontalProgressBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);

        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.HorizontalProgressBar);

        mReachColor = ta.getColor(R.styleable.HorizontalProgressBar_progress_reach_color, mReachColor);
        mUnReachColor = ta.getColor(R.styleable.HorizontalProgressBar_progress_unreach_color, mUnReachColor);
        mTextColor = ta.getColor(R.styleable.HorizontalProgressBar_progress_text_color, mTextColor);
        mReachHeight = ta.getDimension(R.styleable.HorizontalProgressBar_progress_reach_height, mReachHeight);
        mUnReachHeight = ta.getDimension(R.styleable.HorizontalProgressBar_progress_unreach_height, mUnReachHeight);
        mTextSize = ta.getDimension(R.styleable.HorizontalProgressBar_progress_text_size, mTextSize);
        mTextOffset = ta.getDimension(R.styleable.HorizontalProgressBar_progress_text_offset, mTextOffset);

        ta.recycle();

        mPaint.setTextSize(mTextSize);
    }

    public HorizontalProgressBar(Context context) {
        this(context, null);
    }

    @Override
    protected synchronized void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {

        //这里的宽度应该是一个确定的值，要不然没有意义
        int widthSize = MeasureSpec.getSize(widthMeasureSpec);
        int height = measureHeight(heightMeasureSpec);

        setMeasuredDimension(widthSize, height);

        mRealWidth = getMeasuredWidth() - getPaddingLeft() - getPaddingRight();

    }

    private int measureHeight(int heightMeasureSpec) {
        int result = 0;
        int mode = MeasureSpec.getMode(heightMeasureSpec);
        int size = MeasureSpec.getSize(heightMeasureSpec);
        if (mode == MeasureSpec.EXACTLY) {
            result = size;
        } else {
            //mPaint.setTextSize(mTextSize); 可以求得文字的高度
            int textHeight = (int) (mPaint.descent() - mPaint.ascent());

            System.out.println("measureHeight---"+"descent:"+mPaint.descent()+"---ascent:"+mPaint.ascent());
            result = (int) (getPaddingBottom() + getPaddingTop() +
                    Math.max(textHeight, Math.max(mReachHeight, mUnReachHeight)));

            if (mode == MeasureSpec.AT_MOST) {
                result = Math.min(result, size);
            }
        }
        return result;
    }

    @Override
    protected synchronized void onDraw(Canvas canvas) {
        canvas.save();

        canvas.translate(getPaddingLeft(), getHeight() / 2);
        //100% 的时候不需要绘制unreach bar
        boolean noNeedUnReach = false;
        String text = getProgress() + "%";
        int textWidth = (int) mPaint.measureText(text);

        float radio = getProgress() * 1.0f / getMax();
        float endX = radio * (mRealWidth - 2 * mTextOffset - textWidth);

        if (endX + 2 * mTextOffset + textWidth > mRealWidth) {
            endX = mRealWidth - 2 * mTextOffset - textWidth;
            noNeedUnReach = true;
        }

        if (endX > 0) {
            mPaint.setColor(mReachColor);
            mPaint.setStrokeWidth(mReachHeight);
            canvas.drawLine(0, 0, endX, 0, mPaint);
        }

        //draw text
        mPaint.setColor(mTextColor);
        int startX = (int) (endX + mTextOffset);
        int startY = (int) (-(mPaint.ascent() + mPaint.descent()) / 2);
        System.out.println("draw---"+"descent:"+mPaint.descent()+"---ascent:"+mPaint.ascent());

        canvas.drawText(text, startX, startY, mPaint);

        if (!noNeedUnReach) {
            float start = endX + mTextOffset * 2 + textWidth;
            mPaint.setColor(mUnReachColor);
            mPaint.setStrokeWidth(mUnReachHeight);
            canvas.drawLine(start, 0, mRealWidth, 0, mPaint);
        }

        canvas.restore();
    }

    protected float dp2px(float dpValue) {
        return TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, dpValue,
                getContext().getResources().getDisplayMetrics());
    }

    protected float sp2px(float spValue) {
        return TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_SP, spValue,
                getContext().getResources().getDisplayMetrics());
    }

}
