/*
 * Decompiled with CFR 0.152.
 */
package com.xgc1986.ripplebutton.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.InsetDrawable;
import android.graphics.drawable.RippleDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.widget.Button;
import com.xgc1986.ripplebutton.R;

public class RippleButton
extends Button {
    private int buttonColor = -2697257;
    private int rippleColor = 0x40000000;

    public RippleButton(Context context) {
        super(context);
    }

    public RippleButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.manageAttibuteSet(attrs);
    }

    public RippleButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.manageAttibuteSet(attrs);
    }

    @TargetApi(value=21)
    public RippleButton(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.manageAttibuteSet(attrs);
    }

    @TargetApi(value=21)
    public void setColors(int buttonColor, int controlHighlightColor) {
        this.buttonColor = buttonColor;
        this.rippleColor = controlHighlightColor;
        this.setButtonColor(buttonColor);
        this.setRippleColor(controlHighlightColor);
    }

    @TargetApi(value=21)
    public void setRippleColor(int color) {
        this.rippleColor = color;
        if (this.rippleColor == 0) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            Drawable drawable2 = this.getBackground();
            if (drawable2 instanceof RippleDrawable) {
                RippleDrawable rippleDrawable = (RippleDrawable)drawable2;
                ColorStateList colorStateList = new ColorStateList((int[][])new int[][]{{16842919}, {16842908}, {16843518}, {0}}, new int[]{this.rippleColor, this.rippleColor, this.rippleColor, this.buttonColor});
                rippleDrawable.setColor(colorStateList);
            } else {
                Log.w((String)"RippleButton", (String)"The Background must be a RippleDrawable instance.");
            }
        }
    }

    public void setButtonColor(int color) {
        this.buttonColor = color;
        if (this.buttonColor == 0) {
            return;
        }
        Drawable drawable2 = this.getBackground();
        if (Build.VERSION.SDK_INT >= 21) {
            if (drawable2 instanceof RippleDrawable) {
                RippleDrawable rippleDrawable = (RippleDrawable)drawable2.mutate().getConstantState().newDrawable();
                rippleDrawable.setTint(color);
                InsetDrawable insetDrawable = (InsetDrawable)rippleDrawable.getDrawable(0);
                GradientDrawable gradientDrawable = (GradientDrawable)insetDrawable.getDrawable();
                this.setBackground((Drawable)rippleDrawable);
                gradientDrawable.setColor(color);
            } else {
                Log.w((String)"RippleButton", (String)"The Background must be a RippleDrawable instance.");
            }
        } else {
            this.setBackground(this.getResources().getDrawable(R.drawable.btn_default_ripple));
            this.getBackground().setColorFilter(color, PorterDuff.Mode.MULTIPLY);
        }
    }

    private void manageAttibuteSet(AttributeSet attrs) {
        TypedArray ta;
        int[] tAttrs;
        int s = attrs.getStyleAttribute();
        if (Build.VERSION.SDK_INT >= 21) {
            tAttrs = new int[]{16843820, 16843819};
            ta = this.getContext().getTheme().obtainStyledAttributes(tAttrs);
            this.buttonColor = ta.getColor(1, 0);
            this.rippleColor = ta.getColor(0, 0);
            ta.recycle();
        } else {
            tAttrs = new int[]{R.attr.colorControlHighlight, R.attr.colorButtonNormal};
            ta = this.getContext().getTheme().obtainStyledAttributes(s, tAttrs);
            this.buttonColor = ta.getColor(1, 0);
            this.rippleColor = ta.getColor(0, 0);
            ta.recycle();
        }
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.RippleButton);
        int nColor = a.getColor(R.styleable.RippleButton_buttonColor, this.buttonColor);
        int hColor = a.getColor(R.styleable.RippleButton_rippleColor, this.rippleColor);
        a.recycle();
        this.buttonColor = nColor;
        this.rippleColor = hColor;
        this.setButtonColor(nColor);
        this.setRippleColor(hColor);
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean b = super.onTouchEvent(event);
        if (Build.VERSION.SDK_INT < 21) {
            if (event.getActionMasked() == 1) {
                if (this.buttonColor != 0) {
                    this.getBackground().setColorFilter(this.buttonColor, PorterDuff.Mode.MULTIPLY);
                } else {
                    this.getBackground().clearColorFilter();
                }
            } else if (this.rippleColor != 0) {
                this.setBackground(this.getResources().getDrawable(R.drawable.btn_default_normal_ripple));
                this.getBackground().setColorFilter(this.rippleColor, PorterDuff.Mode.MULTIPLY);
            }
        }
        return b;
    }
}

