/*
 * Decompiled with CFR 0.152.
 */
package com.xgc1986.ripplebutton.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.InsetDrawable;
import android.graphics.drawable.RippleDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.widget.ImageButton;
import com.xgc1986.ripplebutton.R;

public class RippleImageButton
extends ImageButton {
    private int buttonColor = -2697257;
    private int rippleColor = 0x40000000;

    public RippleImageButton(Context context) {
        super(context);
    }

    public RippleImageButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.manageAttibuteSet(attrs);
    }

    public RippleImageButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.manageAttibuteSet(attrs);
    }

    @TargetApi(value=21)
    public RippleImageButton(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.manageAttibuteSet(attrs);
    }

    @TargetApi(value=21)
    public void setColors(int buttonColor, int controlHighlightColor) {
        this.setButtonColor(buttonColor);
        this.setRippleColor(controlHighlightColor);
    }

    @TargetApi(value=21)
    public void setRippleColor(int color) {
        this.rippleColor = color;
        if (Build.VERSION.SDK_INT >= 21) {
            Drawable drawable2 = this.getBackground();
            if (drawable2 instanceof RippleDrawable) {
                RippleDrawable rippleDrawable = (RippleDrawable)drawable2;
                ColorStateList colorStateList = new ColorStateList((int[][])new int[][]{{16842919}}, new int[]{this.rippleColor});
                rippleDrawable.setColor(colorStateList);
            } else {
                Log.w((String)"RippleButton", (String)"The Background must be a RippleDrawable instance.");
            }
        }
    }

    public void setButtonColor(int color) {
        this.buttonColor = color;
        Drawable drawable2 = this.getBackground();
        if (Build.VERSION.SDK_INT >= 21) {
            if (drawable2 instanceof RippleDrawable) {
                RippleDrawable rippleDrawable = (RippleDrawable)drawable2.mutate().getConstantState().newDrawable();
                InsetDrawable insetDrawable = (InsetDrawable)rippleDrawable.getDrawable(0);
                GradientDrawable gradientDrawable = (GradientDrawable)insetDrawable.getDrawable();
                this.setBackground((Drawable)rippleDrawable);
                gradientDrawable.setColor(color);
            } else {
                Log.w((String)"RippleButton", (String)"The Background must be a RippleDrawable instance.");
            }
        } else if (Build.VERSION.SDK_INT >= 16) {
            this.setBackground(this.getResources().getDrawable(R.drawable.btn_default_ripple));
            this.getBackground().setColorFilter(color, PorterDuff.Mode.MULTIPLY);
        } else {
            this.getBackground().setColorFilter(color, PorterDuff.Mode.MULTIPLY);
        }
    }

    private void manageAttibuteSet(AttributeSet attrs) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.RippleButton);
        int nColor = a.getInt(R.styleable.RippleButton_buttonColor, this.buttonColor);
        int hColor = a.getInt(R.styleable.RippleButton_rippleColor, this.rippleColor);
        this.setButtonColor(nColor);
        this.setRippleColor(hColor);
        a.recycle();
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean b = super.onTouchEvent(event);
        if (Build.VERSION.SDK_INT < 21) {
            if (Build.VERSION.SDK_INT >= 11) {
                if (event.getActionMasked() == 1) {
                    if (this.buttonColor != 0) {
                        this.getBackground().setColorFilter(this.buttonColor, PorterDuff.Mode.MULTIPLY);
                    } else {
                        this.getBackground().clearColorFilter();
                    }
                } else if (this.rippleColor != 0) {
                    if (Build.VERSION.SDK_INT >= 16) {
                        this.setBackground(this.getResources().getDrawable(R.drawable.btn_default_normal_ripple));
                    } else {
                        this.setBackgroundDrawable(this.getResources().getDrawable(R.drawable.btn_default_normal_ripple));
                    }
                    this.getBackground().setColorFilter(this.rippleColor, PorterDuff.Mode.MULTIPLY);
                }
            } else if (event.getActionMasked() == 1) {
                if (this.buttonColor != 0) {
                    this.getBackground().setColorFilter(this.buttonColor, PorterDuff.Mode.MULTIPLY);
                } else {
                    this.getBackground().clearColorFilter();
                }
            } else if (this.rippleColor != 0) {
                this.getBackground().setColorFilter(this.rippleColor, PorterDuff.Mode.MULTIPLY);
            }
        }
        return b;
    }
}

