package com.xgc1986.ripplebutton.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.InsetDrawable;
import android.graphics.drawable.RippleDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.widget.Button;

public class RippleButton extends Button {
    public RippleButton(Context context) {
        super(context);
    }

    public RippleButton(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public RippleButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    public RippleButton(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    public void setColors(int buttonColor, int controlHighlightColor) {
        setColorButtonNormal(buttonColor);
        setColorControlHighlight(controlHighlightColor);
    }

    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    public void setColorControlHighlight(int color) {

        Drawable drawable = getBackground();

        if (drawable instanceof RippleDrawable) {
            RippleDrawable rippleDrawable = (RippleDrawable) drawable;

            ColorStateList colorStateList = new ColorStateList(
                    new int[][] {
                            new int[]{android.R.attr.state_pressed}
                    },
                    new int[] {
                            color
                    }
            );

            rippleDrawable.setColor(colorStateList);
        } else {
            // TODO print warning
        }
    }

    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    public void setColorButtonNormal(int color) {
        Drawable drawable = getBackground();

        if (drawable instanceof RippleDrawable) {
            RippleDrawable rippleDrawable = (RippleDrawable) drawable;

            InsetDrawable insetDrawable = (InsetDrawable) rippleDrawable.getDrawable(0);
            GradientDrawable gradientDrawable = (GradientDrawable) insetDrawable.getDrawable();
            gradientDrawable.setColor(color);
        } else {
            // TODO print warning
        }
    }
}
