/*
 * Decompiled with CFR 0.152.
 */
package com.xgc1986.ripplebutton.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.InsetDrawable;
import android.graphics.drawable.RippleDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.widget.Button;
import com.xgc1986.ripplebutton.R;

public class RippleButton
extends Button {
    private int buttonColor = 0;
    private int rippleColor = 0;

    public RippleButton(Context context) {
        super(context);
    }

    public RippleButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.manageAttibuteSet(attrs);
    }

    public RippleButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public RippleButton(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @TargetApi(value=21)
    public void setColors(int buttonColor, int controlHighlightColor) {
        this.setButtonColor(buttonColor);
        this.setRippleColor(controlHighlightColor);
    }

    @TargetApi(value=21)
    public void setRippleColor(int color) {
        this.rippleColor = color;
        if (Build.VERSION.SDK_INT >= 21) {
            Drawable drawable = this.getBackground();
            if (drawable instanceof RippleDrawable) {
                RippleDrawable rippleDrawable = (RippleDrawable)drawable;
                ColorStateList colorStateList = new ColorStateList((int[][])new int[][]{{16842919}}, new int[]{color});
                rippleDrawable.setColor(colorStateList);
            } else {
                Log.w((String)"RippleButton", (String)"The Background must be a RippleDrawable instance.");
            }
        }
    }

    @TargetApi(value=21)
    public void setButtonColor(int color) {
        this.buttonColor = color;
        Drawable drawable = this.getBackground();
        if (Build.VERSION.SDK_INT >= 21) {
            if (drawable instanceof RippleDrawable) {
                RippleDrawable rippleDrawable = (RippleDrawable)drawable;
                InsetDrawable insetDrawable = (InsetDrawable)rippleDrawable.getDrawable(0);
                GradientDrawable gradientDrawable = (GradientDrawable)insetDrawable.getDrawable();
                gradientDrawable.setColor(color);
            } else {
                Log.w((String)"RippleButton", (String)"The Background must be a RippleDrawable instance.");
            }
        } else {
            this.getBackground().setColorFilter(color, PorterDuff.Mode.SRC_IN);
        }
    }

    private void manageAttibuteSet(AttributeSet attrs) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.RippleButton);
        int nColor = a.getInt(R.styleable.RippleButton_buttonColor, 0);
        int hColor = a.getInt(R.styleable.RippleButton_rippleColor, 0);
        if (nColor != 0) {
            this.setButtonColor(nColor);
        }
        if (hColor != 0) {
            this.setRippleColor(hColor);
        }
        a.recycle();
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean b = super.onTouchEvent(event);
        if (Build.VERSION.SDK_INT < 21) {
            if (event.getActionMasked() == 1) {
                if (this.buttonColor != 0) {
                    this.getBackground().setColorFilter(this.buttonColor, PorterDuff.Mode.SRC_IN);
                }
            } else if (this.rippleColor != 0) {
                this.getBackground().setColorFilter(this.rippleColor, PorterDuff.Mode.SRC_IN);
            }
        }
        return b;
    }
}

