package com.xfvape.uid.spring.boot;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xfvape.uid.buffer.RejectedTakeBufferHandler;
import com.xfvape.uid.buffer.RingBuffer;

public class DefaultRejectedTakeBufferHandler implements RejectedTakeBufferHandler {
	private Logger logger = LoggerFactory.getLogger(getClass());

	@Override
	public void rejectTakeBuffer(RingBuffer ringBuffer) {
		logger.warn("Rejected take buffer. {}", ringBuffer);
        throw new RuntimeException("Rejected take buffer. " + ringBuffer);
	}
	
}
