/*
 * Decompiled with CFR 0.152.
 */
package com.xeoh.android.texthighlighter;

import android.text.Spannable;
import android.text.SpannableString;
import android.text.style.BackgroundColorSpan;
import android.text.style.CharacterStyle;
import android.text.style.ForegroundColorSpan;
import android.text.style.StyleSpan;
import android.view.View;
import android.widget.TextView;
import java.util.ArrayList;

public class TextHighlighter {
    private ForegroundColorSpan fgColor;
    private BackgroundColorSpan bgColor;
    private boolean bold = false;
    private boolean italic = false;
    private ArrayList<TextView> textViews = new ArrayList();
    private String highlightedText = null;
    public static final Matcher BASE_MATCHER = new Matcher(){

        @Override
        public ArrayList<Integer> getMatchIndices(String origin, String keyword) {
            ArrayList<Integer> indices = new ArrayList<Integer>();
            int index = origin.indexOf(keyword, 0);
            while (index != -1) {
                indices.add(index);
                index = origin.indexOf(keyword, index + 1);
            }
            return indices;
        }

        @Override
        public boolean isHighlightable(String origin, String keyword) {
            return this.getMatchIndices(origin, keyword).size() > 0;
        }
    };
    public static final Matcher CASE_INSENSITIVE_MATCHER = new Matcher(){

        @Override
        public ArrayList<Integer> getMatchIndices(String origin, String keyword) {
            ArrayList<Integer> indices = new ArrayList<Integer>();
            origin = origin.toLowerCase();
            keyword = keyword.toLowerCase();
            int index = origin.indexOf(keyword, 0);
            while (index != -1) {
                indices.add(index);
                index = origin.indexOf(keyword, index + 1);
            }
            return indices;
        }

        @Override
        public boolean isHighlightable(String origin, String keyword) {
            return this.getMatchIndices(origin, keyword).size() > 0;
        }
    };

    public TextHighlighter setForegroundColor(int color) {
        this.fgColor = new ForegroundColorSpan(color);
        return this;
    }

    public TextHighlighter resetForegroundColor() {
        this.fgColor = null;
        return this;
    }

    public TextHighlighter setBackgroundColor(int color) {
        this.bgColor = new BackgroundColorSpan(color);
        return this;
    }

    public TextHighlighter resetBackgroundColor() {
        this.bgColor = null;
        return this;
    }

    public TextHighlighter setBold(boolean bold) {
        this.bold = bold;
        return this;
    }

    public TextHighlighter setItalic(boolean italic) {
        this.italic = italic;
        return this;
    }

    public TextHighlighter addTarget(View view) {
        if (view instanceof TextView && !this.textViews.contains(view)) {
            this.textViews.add((TextView)view);
        }
        return this;
    }

    public void resetTargets() {
        this.textViews = new ArrayList();
    }

    public void highlight(String keyword, Matcher matcher) {
        this.highlightedText = keyword;
        if (keyword == null || keyword.isEmpty()) {
            this.reset();
            return;
        }
        for (TextView textView : this.textViews) {
            this.highlightTextView(textView, keyword, matcher);
        }
    }

    public void invalidate(Matcher matcher) {
        this.highlight(this.highlightedText, matcher);
    }

    private Spannable getHighlightedText(String origin, String keyword, ArrayList<Integer> indices) {
        return this.getHighlightedText((Spannable)new SpannableString((CharSequence)origin), keyword, indices);
    }

    private Spannable getHighlightedText(Spannable origin, String keyword, ArrayList<Integer> indices) {
        boolean noop;
        SpannableString spannable = new SpannableString((CharSequence)origin.toString());
        boolean bl = noop = origin.toString().isEmpty() || this.fgColor == null && this.bgColor == null && !this.bold && !this.italic;
        if (noop) {
            return spannable;
        }
        for (int index = 0; index < origin.toString().length(); ++index) {
            for (CharacterStyle style : (CharacterStyle[])origin.getSpans(index, index + 1, CharacterStyle.class)) {
                if (style instanceof StyleSpan) continue;
                spannable.setSpan((Object)CharacterStyle.wrap((CharacterStyle)style), index, index + 1, 0);
            }
        }
        for (int index : indices) {
            if (this.fgColor != null) {
                spannable.setSpan((Object)CharacterStyle.wrap((CharacterStyle)this.fgColor), index, index + keyword.length(), 0);
            }
            if (this.bgColor != null) {
                spannable.setSpan((Object)CharacterStyle.wrap((CharacterStyle)this.bgColor), index, index + keyword.length(), 0);
            }
            if (!this.bold && !this.italic) {
                spannable.setSpan((Object)new StyleSpan(0), index, index + keyword.length(), 0);
                continue;
            }
            if (this.bold && !this.italic) {
                spannable.setSpan((Object)new StyleSpan(1), index, index + keyword.length(), 0);
                continue;
            }
            if (!this.bold && this.italic) {
                spannable.setSpan((Object)new StyleSpan(2), index, index + keyword.length(), 0);
                continue;
            }
            spannable.setSpan((Object)new StyleSpan(3), index, index + keyword.length(), 0);
        }
        return spannable;
    }

    private void highlightTextView(TextView textView, String keyword, Matcher matcher) {
        if (textView == null) {
            return;
        }
        ArrayList<Integer> indices = matcher.getMatchIndices(textView.getText().toString(), keyword);
        if (textView.getText() instanceof Spannable) {
            textView.setText((CharSequence)this.getHighlightedText((Spannable)textView.getText(), keyword, indices), TextView.BufferType.SPANNABLE);
        } else {
            textView.setText((CharSequence)this.getHighlightedText(textView.getText().toString(), keyword, indices), TextView.BufferType.SPANNABLE);
        }
    }

    private void resetTextView(TextView textView) {
        if (textView != null) {
            textView.setText((CharSequence)textView.getText().toString());
        }
    }

    private void reset() {
        for (TextView textView : this.textViews) {
            this.resetTextView(textView);
        }
    }

    public static interface Matcher {
        public ArrayList<Integer> getMatchIndices(String var1, String var2);

        public boolean isHighlightable(String var1, String var2);
    }
}

