/*
 * Decompiled with CFR 0.152.
 */
package com.xeoh.android.texthighlighter;

import android.text.Spannable;
import android.text.SpannableString;
import android.text.style.BackgroundColorSpan;
import android.text.style.CharacterStyle;
import android.text.style.ForegroundColorSpan;
import android.view.View;
import android.widget.TextView;
import java.util.ArrayList;

public class TextHighlighter {
    private ForegroundColorSpan fgColor;
    private BackgroundColorSpan bgColor;
    private ArrayList<TextView> textViews = new ArrayList();
    private String highlightedText = null;
    public static final Matcher BASE_MATCHER = new Matcher(){

        @Override
        public ArrayList<Integer> getMatchIndices(String origin, String keyword) {
            ArrayList<Integer> indices = new ArrayList<Integer>();
            int index = origin.indexOf(keyword, 0);
            while (index != -1) {
                indices.add(index);
                index = origin.indexOf(keyword, index + 1);
            }
            return indices;
        }

        @Override
        public boolean isHighlightable(String origin, String keyword) {
            return this.getMatchIndices(origin, keyword).size() > 0;
        }
    };
    public static final Matcher CASE_INSENSITIVE_MATCHER = new Matcher(){

        @Override
        public ArrayList<Integer> getMatchIndices(String origin, String keyword) {
            ArrayList<Integer> indices = new ArrayList<Integer>();
            origin = origin.toLowerCase();
            keyword = keyword.toLowerCase();
            int index = origin.indexOf(keyword, 0);
            while (index != -1) {
                indices.add(index);
                index = origin.indexOf(keyword, index + 1);
            }
            return indices;
        }

        @Override
        public boolean isHighlightable(String origin, String keyword) {
            return this.getMatchIndices(origin, keyword).size() > 0;
        }
    };

    public TextHighlighter setForegroundColor(int color) {
        this.fgColor = new ForegroundColorSpan(color);
        return this;
    }

    public TextHighlighter resetForegroundColor() {
        this.fgColor = null;
        return this;
    }

    public TextHighlighter setBackgroundColor(int color) {
        this.bgColor = new BackgroundColorSpan(color);
        return this;
    }

    public TextHighlighter resetBackgroundColor() {
        this.bgColor = null;
        return this;
    }

    public TextHighlighter addTarget(View view) {
        if (view instanceof TextView && !this.textViews.contains(view)) {
            this.textViews.add((TextView)view);
        }
        return this;
    }

    public void resetTargets() {
        this.textViews = new ArrayList();
    }

    public void highlight(String keyword, Matcher matcher) {
        this.highlightedText = keyword;
        if (keyword == null || keyword.isEmpty()) {
            this.reset();
            return;
        }
        for (TextView textView : this.textViews) {
            this.highlightTextView(textView, keyword, matcher);
        }
    }

    public void invalidate(Matcher matcher) {
        this.highlight(this.highlightedText, matcher);
    }

    private Spannable getHighlightedText(String origin, String keyword, ArrayList<Integer> indices) {
        SpannableString spannable = new SpannableString((CharSequence)origin);
        if (origin.isEmpty() || this.fgColor == null && this.bgColor == null) {
            return spannable;
        }
        for (int index : indices) {
            if (this.fgColor != null) {
                spannable.setSpan((Object)CharacterStyle.wrap((CharacterStyle)this.fgColor), index, index + keyword.length(), 0);
            }
            if (this.bgColor == null) continue;
            spannable.setSpan((Object)CharacterStyle.wrap((CharacterStyle)this.bgColor), index, index + keyword.length(), 0);
        }
        return spannable;
    }

    private void highlightTextView(TextView textView, String keyword, Matcher matcher) {
        if (textView == null) {
            return;
        }
        ArrayList<Integer> indices = matcher.getMatchIndices(textView.getText().toString(), keyword);
        textView.setText((CharSequence)this.getHighlightedText(textView.getText().toString(), keyword, indices));
    }

    private void resetTextView(TextView textView) {
        if (textView != null) {
            textView.setText((CharSequence)textView.getText().toString());
        }
    }

    private void reset() {
        for (TextView textView : this.textViews) {
            this.resetTextView(textView);
        }
    }

    public static interface Matcher {
        public ArrayList<Integer> getMatchIndices(String var1, String var2);

        public boolean isHighlightable(String var1, String var2);
    }
}

