/*
 * Decompiled with CFR 0.152.
 */
package com.xeoh.android.checkboxgroup;

import android.widget.CheckBox;
import android.widget.CompoundButton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CheckBoxGroup<T> {
    private Map<CheckBox, T> checkBoxToValue;
    private Map<T, CheckBox> valueToCheckBox;
    private CheckedChangeListener<T> listener;
    private CompoundButton.OnCheckedChangeListener checkedChangeListener = new CompoundButton.OnCheckedChangeListener(){

        public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
            if (CheckBoxGroup.this.listener != null) {
                CheckBoxGroup.this.listener.onCheckedChange(CheckBoxGroup.this.getValues());
            }
        }
    };

    public CheckBoxGroup(Map<CheckBox, T> checkBoxes, CheckedChangeListener<T> listener) {
        this.checkBoxToValue = checkBoxes;
        this.listener = listener;
        this.valueToCheckBox = new HashMap<T, CheckBox>();
        for (Map.Entry<CheckBox, T> entry : this.checkBoxToValue.entrySet()) {
            this.valueToCheckBox.put(entry.getValue(), entry.getKey());
            entry.getKey().setOnCheckedChangeListener(this.checkedChangeListener);
        }
    }

    public void put(CheckBox checkBox, T value, boolean checked) {
        if (!this.checkBoxToValue.containsKey(checkBox) && !this.valueToCheckBox.containsKey(value)) {
            this.checkBoxToValue.put(checkBox, value);
            this.valueToCheckBox.put(value, checkBox);
            checkBox.setChecked(checked);
            this.listener.onCheckedChange(this.getValues());
            checkBox.setOnCheckedChangeListener(this.checkedChangeListener);
        }
    }

    public void remove(CheckBox checkBox) {
        if (this.checkBoxToValue.containsKey(checkBox)) {
            T value = this.checkBoxToValue.get(checkBox);
            checkBox.setOnCheckedChangeListener(null);
            this.valueToCheckBox.remove(value);
            this.checkBoxToValue.remove(checkBox);
            this.listener.onCheckedChange(this.getValues());
        }
    }

    public ArrayList<T> getValues() {
        ArrayList<T> values = new ArrayList<T>();
        if (this.checkBoxToValue == null || this.checkBoxToValue.isEmpty()) {
            return values;
        }
        for (Map.Entry<CheckBox, T> entry : this.checkBoxToValue.entrySet()) {
            if (!entry.getKey().isChecked()) continue;
            values.add(entry.getValue());
        }
        return values;
    }

    public void setValues(List<T> options) {
        if (options == null) {
            for (CheckBox checkBox : this.checkBoxToValue.keySet()) {
                checkBox.setChecked(false);
            }
            return;
        }
        for (Map.Entry<CheckBox, T> entry : this.checkBoxToValue.entrySet()) {
            entry.getKey().setChecked(options.contains(entry.getValue()));
        }
        if (this.listener != null) {
            this.listener.onCheckedChange(this.getValues());
        }
    }

    public void toggleCheckBox(T value) {
        CheckBox checkBox;
        checkBox.setChecked(!(checkBox = this.valueToCheckBox.get(value)).isChecked());
        if (this.listener != null) {
            this.listener.onCheckedChange(this.getValues());
        }
    }

    public static interface CheckedChangeListener<T> {
        public void onCheckedChange(ArrayList<T> var1);
    }
}

