/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver;

import com.xenoterracide.gradle.git.GitExtension;
import com.xenoterracide.gradle.git.GitRemoteForGradle;
import com.xenoterracide.gradle.git.GitStatus;
import com.xenoterracide.gradle.git.ProvidedFactory;
import com.xenoterracide.gradle.git.Provides;
import com.xenoterracide.gradle.semver.SemverBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.gradle.api.Incubating;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.jspecify.annotations.Nullable;
import org.semver4j.Semver;

public class SemverExtension
implements Provides<Semver> {
    private final Logger log = Logging.getLogger(this.getClass());
    private final Property<Semver> provider;
    private final Property<Boolean> checkDirty;
    private final Property<String> remote;
    private final Project project;

    private SemverExtension(Project project) {
        this.project = project;
        ProvidedFactory pf = new ProvidedFactory(project);
        this.provider = pf.property(Semver.class);
        this.checkDirty = pf.propertyBoolean();
        this.remote = pf.propertyString();
    }

    static SemverExtension forProject(Project project) {
        return new SemverExtension(project).build();
    }

    static Optional<GitRemoteForGradle> getOrigin(List<GitRemoteForGradle> remotes) {
        return remotes.stream().filter(remote -> Objects.equals(remote.getName(), "origin")).filter(remote -> remote.getHeadBranch().isPresent()).findAny();
    }

    static Provider<String> getBranch(GitExtension gitExt) {
        return gitExt.getRemotes().map(remotes -> SemverExtension.getOrigin(remotes).map(remote -> (String)remote.getHeadBranch().get())).filter(Optional::isPresent).map(Optional::get).zip(gitExt.getBranch(), (remoteBranch, localBranch) -> Objects.equals(remoteBranch, localBranch) ? null : localBranch);
    }

    static Function<GitRemoteForGradle, @Nullable Long> commonAncestorDistanceFor(GitExtension gitExt) {
        return remote -> gitExt.commonAncestorDistanceFor(remote).orElse(null);
    }

    static Provider<Long> getDistance(GitExtension gitExt) {
        return gitExt.getRemotes().map(SemverExtension::getOrigin).filter(Optional::isPresent).map(Optional::get).zip(gitExt.getBranch(), (remote, local) -> Objects.equals(remote.headBranch(), local) ? null : remote).map(SemverExtension.commonAncestorDistanceFor(gitExt)::apply).orElse(gitExt.getDistance());
    }

    Transformer<Semver, Semver> configureBuilder(GitExtension gitExt) {
        return semver -> new SemverBuilder((Semver)semver).withDirtyOut((Boolean)this.getCheckDirty().getOrElse((Object)false)).withPreReleaseDistance((Long)SemverExtension.getDistance(gitExt).getOrElse((Object)0L)).withBuildDistance((Long)gitExt.getDistance().getOrElse((Object)0L)).withGitStatus((GitStatus)gitExt.getStatus().get()).withUniqueShort((String)gitExt.getUniqueShort().getOrNull()).withBranch((String)SemverExtension.getBranch(gitExt).getOrNull()).build();
    }

    SemverExtension build() {
        GitExtension gitExt = (GitExtension)this.project.getExtensions().getByType(GitExtension.class);
        Provider semverProvider = gitExt.getTag().map(tag -> Objects.requireNonNull(Semver.parse((String)tag))).orElse((Object)Semver.ZERO).map(this.configureBuilder(gitExt)).map(semver -> {
            this.log.info("semver {} {}", (Object)this.project.getName(), semver);
            return semver;
        });
        this.provider.set(semverProvider);
        this.provider.finalizeValueOnRead();
        this.provider.disallowChanges();
        return this;
    }

    public Provider<Semver> getProvider() {
        return this.provider;
    }

    public Property<Boolean> getCheckDirty() {
        return this.checkDirty;
    }

    @Incubating
    public Property<String> getRemote() {
        return this.remote;
    }
}

